/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.directvm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultAsyncProducer;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumer;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumerNotAvailableException;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ChainProducer.class);
    private final ChainEndpoint endpoint;

    public ChainProducer(ChainEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        ChainConsumer consumer = this.endpoint.getComponent().getConsumer(this.endpoint);
        if (consumer == null) {
            if (this.endpoint.isFailIfNoConsumers()) {
                exchange.setException((Throwable)new ChainConsumerNotAvailableException("No consumers available on endpoint: " + String.valueOf(this.endpoint), exchange));
            } else {
                LOG.debug("message ignored, no consumers available on endpoint: {}", (Object)this.endpoint);
            }
            callback.done(true);
            return true;
        }
        try {
            Exchange submitted;
            HeaderFilterStrategy headerFilterStrategy = this.endpoint.getHeaderFilterStrategy();
            Exchange exchange2 = submitted = !this.endpoint.isPropagateProperties() || headerFilterStrategy != null ? exchange.copy() : exchange;
            if (!this.endpoint.isPropagateProperties()) {
                submitted.getProperties().clear();
            }
            if (headerFilterStrategy != null) {
                submitted.getIn().getHeaders().entrySet().removeIf(e -> headerFilterStrategy.applyFilterToCamelHeaders((String)e.getKey(), e.getValue(), submitted));
            }
            return consumer.getAsyncProcessor().process(submitted, done -> {
                try {
                    Message msg = submitted.getMessage();
                    if (headerFilterStrategy != null) {
                        msg.getHeaders().entrySet().removeIf(e -> headerFilterStrategy.applyFilterToExternalHeaders((String)e.getKey(), e.getValue(), submitted));
                    }
                    if (exchange != submitted) {
                        exchange.setException((Throwable)submitted.getException());
                        exchange.getOut().copyFrom(msg);
                    }
                    if (this.endpoint.isPropagateProperties()) {
                        exchange.getProperties().putAll(submitted.getProperties());
                    }
                }
                catch (Exception e2) {
                    exchange.setException((Throwable)e2);
                }
                finally {
                    callback.done(done);
                }
            });
        }
        catch (Exception e2) {
            exchange.setException((Throwable)e2);
            callback.done(true);
            return true;
        }
    }
}

