/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.opensearch.ism.deserializers;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.Action;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.ActionRetry;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.AllocationAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.CloseAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.DeleteAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.ForceMergeAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.IndexPriorityAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.NotificationAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.OpenAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.ReadOnlyAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.ReadWriteAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.ReplicaCountAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.RolloverAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.RollupAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.ShrinkAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.actions.SnapshotAction;
import org.qubership.integration.platform.engine.opensearch.ism.model.time.TimeValue;

public class ActionDeserializer
extends JsonDeserializer<Action> {
    private static final Map<String, Class<? extends Action>> CLASS_MAP = Map.ofEntries(new AbstractMap.SimpleEntry<String, Class<ForceMergeAction>>("force_merge", ForceMergeAction.class), new AbstractMap.SimpleEntry<String, Class<ReadOnlyAction>>("read_only", ReadOnlyAction.class), new AbstractMap.SimpleEntry<String, Class<ReadWriteAction>>("read_write", ReadWriteAction.class), new AbstractMap.SimpleEntry<String, Class<ReplicaCountAction>>("replica_count", ReplicaCountAction.class), new AbstractMap.SimpleEntry<String, Class<ShrinkAction>>("shrink", ShrinkAction.class), new AbstractMap.SimpleEntry<String, Class<CloseAction>>("close", CloseAction.class), new AbstractMap.SimpleEntry<String, Class<OpenAction>>("open", OpenAction.class), new AbstractMap.SimpleEntry<String, Class<DeleteAction>>("delete", DeleteAction.class), new AbstractMap.SimpleEntry<String, Class<RolloverAction>>("rollover", RolloverAction.class), new AbstractMap.SimpleEntry<String, Class<NotificationAction>>("notification", NotificationAction.class), new AbstractMap.SimpleEntry<String, Class<SnapshotAction>>("snapshot", SnapshotAction.class), new AbstractMap.SimpleEntry<String, Class<IndexPriorityAction>>("index_priority", IndexPriorityAction.class), new AbstractMap.SimpleEntry<String, Class<AllocationAction>>("allocation", AllocationAction.class), new AbstractMap.SimpleEntry<String, Class<RollupAction>>("rollup", RollupAction.class));

    public Action deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        TreeNode node = jsonParser.readValueAsTree();
        if (Objects.isNull(node)) {
            return null;
        }
        if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            return this.deserializeAction(jsonParser, objectNode);
        }
        String message = String.format("Wrong %s field type", jsonParser.getCurrentName());
        throw InvalidFormatException.from((JsonParser)jsonParser, (String)message, (Object)node.asToken().asString(), TimeValue.class);
    }

    private Action deserializeAction(JsonParser jsonParser, ObjectNode node) throws IOException, JacksonException {
        Map.Entry entry = CLASS_MAP.entrySet().stream().filter(e -> node.has((String)e.getKey())).findFirst().orElseThrow(() -> InvalidFormatException.from((JsonParser)jsonParser, (String)"Unsupported action type", (Object)node.asToken().asString(), TimeValue.class));
        Action action = (Action)jsonParser.getCodec().treeToValue((TreeNode)node.get((String)entry.getKey()), (Class)entry.getValue());
        TimeValue timeout = (TimeValue)jsonParser.getCodec().treeToValue((TreeNode)node.get("timeout"), TimeValue.class);
        action.setTimeout(timeout);
        ActionRetry retry = (ActionRetry)jsonParser.getCodec().treeToValue((TreeNode)node.get("retry"), ActionRetry.class);
        action.setRetry(retry);
        return action;
    }
}

