/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotencyRecordData;
import org.qubership.integration.platform.engine.camel.idempotency.IdempotencyRecordStatus;
import org.qubership.integration.platform.engine.persistence.shared.repository.IdempotencyRecordRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IdempotencyRecordService {
    private static final Logger log = LoggerFactory.getLogger(IdempotencyRecordService.class);
    private final ObjectMapper objectMapper;
    private final IdempotencyRecordRepository idempotencyRecordRepository;

    @Autowired
    public IdempotencyRecordService(ObjectMapper objectMapper, IdempotencyRecordRepository idempotencyRecordRepository) {
        this.objectMapper = objectMapper;
        this.idempotencyRecordRepository = idempotencyRecordRepository;
    }

    @Transactional(value="checkpointTransactionManager")
    public boolean insertIfNotExists(String key, int ttl) {
        String data = this.buildIdempotencyRecordData();
        return this.idempotencyRecordRepository.insertIfNotExistsOrUpdateIfExpired(key, data, ttl) > 0;
    }

    @Transactional(value="checkpointTransactionManager")
    public boolean exists(String key) {
        return this.idempotencyRecordRepository.existsByKeyAndNotExpired(key);
    }

    @Transactional(value="checkpointTransactionManager")
    public boolean delete(String key) {
        return this.idempotencyRecordRepository.deleteByKeyAndNotExpired(key) > 0;
    }

    @Scheduled(cron="${qip.idempotency.expired-records-cleanup-cron:0 */5 * ? * *}")
    @Transactional(value="checkpointTransactionManager")
    public void deleteExpired() {
        log.debug("Deleting expired idempotency records.");
        this.idempotencyRecordRepository.deleteExpired();
    }

    private String buildIdempotencyRecordData() {
        try {
            IdempotencyRecordData data = IdempotencyRecordData.builder().status(IdempotencyRecordStatus.RECEIVED).build();
            return this.objectMapper.writeValueAsString((Object)data);
        }
        catch (JsonProcessingException ignored) {
            return null;
        }
    }
}

