/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.ExpressionException;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.SimpleField;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.mapper.ComplexField;

public class MakeObjectFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "makeObject";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() % 2 != 0) {
            String message = String.format("%s expects even number of arguments.", this.getName());
            throw new ParseException(message);
        }
        return ctx -> {
            ArrayList fields = new ArrayList();
            for (int i = 0; i < args.size() / 2; ++i) {
                Optional<String> optionalName = this.evaluate((Expression)args.get(i * 2), ctx).map(Field::getValue).map(Object::toString);
                Optional value = this.evaluate((Expression)args.get(i * 2 + 1), ctx);
                optionalName.map(name -> value.map(valueField -> {
                    Field f = FieldUtils.cloneField((Field)valueField);
                    String prefix = "/result/" + name + this.getCollectionSuffix(valueField.getCollectionType());
                    FieldUtils.replacePathSegments((Field)f, (List)new AtlasPath(f.getPath()).getSegments(true), (List)new AtlasPath(prefix).getSegments(true));
                    f.setName(name);
                    return f;
                }).orElseGet(() -> {
                    SimpleField f = new SimpleField();
                    f.setPath("/result/" + name);
                    f.setName(name);
                    return f;
                })).ifPresent(fields::add);
            }
            ComplexField result = new ComplexField(fields);
            result.setFieldType(FieldType.COMPLEX);
            result.setCollectionType(CollectionType.NONE);
            result.setPath("/result");
            result.setName("result");
            return result;
        };
    }

    private Optional<Field> evaluate(Expression expression, ExpressionContext ctx) throws ExpressionException {
        return Objects.isNull(expression) ? Optional.empty() : Optional.of(expression.evaluate(ctx));
    }

    private String getCollectionSuffix(CollectionType collectionType) {
        return CollectionType.LIST.equals((Object)collectionType) || CollectionType.ARRAY.equals((Object)collectionType) ? "<>" : "";
    }
}

