/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.persistence.shared.entity.Property;
import org.qubership.integration.platform.engine.persistence.shared.entity.SessionInfo;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity(name="checkpoints")
public class Checkpoint {
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.EAGER)
    private SessionInfo session;
    private String checkpointElementId;
    @OneToMany(orphanRemoval=true, mappedBy="checkpoint", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<Property> properties = new LinkedList();
    @Column(columnDefinition="TEXT")
    private String headers;
    @Nullable
    @Column(columnDefinition="TEXT")
    private String contextData;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="body_bytea")
    private byte[] body;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="body")
    @Deprecated
    private byte[] deprecatedBody;
    private Timestamp timestamp;

    public void assignProperties(List<Property> properties) {
        properties.forEach(property -> property.setCheckpoint(this));
        this.getProperties().addAll(properties);
    }

    private static String $default$id() {
        return UUID.randomUUID().toString();
    }

    private static Timestamp $default$timestamp() {
        return Timestamp.from(new Date().toInstant());
    }

    public static CheckpointBuilder builder() {
        return new CheckpointBuilder();
    }

    public String getId() {
        return this.id;
    }

    public SessionInfo getSession() {
        return this.session;
    }

    public String getCheckpointElementId() {
        return this.checkpointElementId;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String getHeaders() {
        return this.headers;
    }

    @Nullable
    public String getContextData() {
        return this.contextData;
    }

    public byte[] getBody() {
        return this.body;
    }

    @Deprecated
    public byte[] getDeprecatedBody() {
        return this.deprecatedBody;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSession(SessionInfo session) {
        this.session = session;
    }

    public void setCheckpointElementId(String checkpointElementId) {
        this.checkpointElementId = checkpointElementId;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public void setContextData(@Nullable String contextData) {
        this.contextData = contextData;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    @Deprecated
    public void setDeprecatedBody(byte[] deprecatedBody) {
        this.deprecatedBody = deprecatedBody;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public Checkpoint(String id, SessionInfo session, String checkpointElementId, List<Property> properties, String headers, @Nullable String contextData, byte[] body, byte[] deprecatedBody, Timestamp timestamp) {
        this.id = id;
        this.session = session;
        this.checkpointElementId = checkpointElementId;
        this.properties = properties;
        this.headers = headers;
        this.contextData = contextData;
        this.body = body;
        this.deprecatedBody = deprecatedBody;
        this.timestamp = timestamp;
    }

    public Checkpoint() {
        this.id = Checkpoint.$default$id();
        this.timestamp = Checkpoint.$default$timestamp();
    }
}

