/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletCustomConsumer;

public class RestConsumerContextPathCustomMatcher {
    public static RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer> matchBestPath(String requestMethod, String requestPath, List<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>> consumerPaths) {
        boolean noWildcards;
        ArrayList<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>> candidates = new ArrayList<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>>();
        for (RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer> entry : consumerPaths) {
            if (!RestConsumerContextPathCustomMatcher.matchRestMethod(requestMethod, entry.getRestrictMethod())) continue;
            candidates.add(entry);
        }
        RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer> answer = RestConsumerContextPathCustomMatcher.matchRestPathAndTime(requestPath, candidates);
        if (answer == null && RestConsumerContextPathCustomMatcher.isOptionsMethod(requestMethod)) {
            candidates.clear();
            candidates.addAll(consumerPaths);
            answer = RestConsumerContextPathCustomMatcher.matchRestPathAndTime(requestPath, candidates);
        }
        if (noWildcards = candidates.stream().allMatch(p -> RestConsumerContextPathCustomMatcher.countWildcards(p.getConsumerPath()) == 0)) {
            answer = RestConsumerContextPathCustomMatcher.matchNewerConsumer(candidates.stream().filter(c -> RestConsumerContextPathMatcher.matchPath((String)requestPath, (String)c.getConsumerPath(), (boolean)c.isMatchOnUriPrefix())).toList());
        }
        if (answer == null) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                RestConsumerContextPathMatcher.ConsumerPath consumer = (RestConsumerContextPathMatcher.ConsumerPath)it.next();
                if (RestConsumerContextPathCustomMatcher.matchRestPath(requestPath, consumer.getConsumerPath(), true)) continue;
                it.remove();
            }
            int bestWildcard = Integer.MAX_VALUE;
            ArrayList<RestConsumerContextPathMatcher.ConsumerPath> wildcardCandidates = null;
            if (candidates.size() > 1) {
                for (RestConsumerContextPathMatcher.ConsumerPath consumerPath : candidates) {
                    int wildcards = RestConsumerContextPathCustomMatcher.countWildcards(consumerPath.getConsumerPath());
                    if (wildcards <= 0) continue;
                    if (wildcardCandidates == null || wildcards < bestWildcard) {
                        wildcardCandidates = new ArrayList<RestConsumerContextPathMatcher.ConsumerPath>();
                        wildcardCandidates.add(consumerPath);
                        bestWildcard = wildcards;
                        continue;
                    }
                    if (wildcards != bestWildcard) continue;
                    wildcardCandidates.add(consumerPath);
                }
                if (wildcardCandidates != null) {
                    answer = RestConsumerContextPathCustomMatcher.matchNewerConsumer(wildcardCandidates);
                }
            }
            if (answer == null && candidates.size() == 1) {
                answer = (RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>)candidates.getFirst();
            }
        }
        return answer;
    }

    private static RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer> matchRestPathAndTime(String requestPath, @Nonnull List<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>> candidates) {
        List<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>> sameCandidates = candidates.stream().filter(path -> RestConsumerContextPathCustomMatcher.matchRestPath(requestPath, path.getConsumerPath(), false)).toList();
        return RestConsumerContextPathCustomMatcher.matchNewerConsumer(sameCandidates);
    }

    private static RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer> matchNewerConsumer(List<RestConsumerContextPathMatcher.ConsumerPath<HttpConsumer>> consumers) {
        return consumers.stream().filter(consumer -> consumer.getConsumer() instanceof ServletCustomConsumer).max((c1, c2) -> Math.toIntExact(((ServletCustomConsumer)((Object)((Object)c1.getConsumer()))).getCreationTime() - ((ServletCustomConsumer)((Object)((Object)c2.getConsumer()))).getCreationTime())).orElse(null);
    }

    private static boolean matchRestMethod(String method, String restrict) {
        if (restrict == null) {
            return true;
        }
        return restrict.toLowerCase(Locale.ENGLISH).contains(method.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isOptionsMethod(String method) {
        return "options".equalsIgnoreCase(method);
    }

    private static boolean matchRestPath(String requestPath, String consumerPath, boolean wildcard) {
        String[] consumerPaths;
        String[] requestPaths;
        if (requestPath == null && consumerPath == null) {
            return true;
        }
        if (requestPath == null || consumerPath == null) {
            return false;
        }
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.endsWith("/")) {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        if ((requestPaths = requestPath.split("/")).length != (consumerPaths = consumerPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < requestPaths.length; ++i) {
            String p1 = requestPaths[i];
            String p2 = consumerPaths[i];
            if (wildcard && p2.startsWith("{") && p2.endsWith("}") || RestConsumerContextPathMatcher.matchPath((String)p1, (String)p2, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private static int countWildcards(String consumerPath) {
        String[] consumerPaths;
        int wildcards = 0;
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        for (String p2 : consumerPaths = consumerPath.split("/")) {
            if (!p2.startsWith("{") || !p2.endsWith("}")) continue;
            ++wildcards;
        }
        return wildcards;
    }
}

