/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.logging.log4j.util.Strings;
import org.qubership.integration.platform.engine.forms.FormData;
import org.qubership.integration.platform.engine.forms.FormEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class FormBuilderProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(FormBuilderProcessor.class);

    public void process(Exchange exchange) throws Exception {
        String bodyMimeType = (String)exchange.getProperty("internalProperty_bodyMimeType", String.class);
        if (Strings.isBlank((String)bodyMimeType)) {
            log.error("Body MIME type is blank.");
            return;
        }
        FormData formData = (FormData)exchange.getProperty("internalProperty_bodyFormData", FormData.class);
        if (Objects.isNull(formData)) {
            log.error("Form data is null.");
            return;
        }
        MediaType contentType = MediaType.valueOf((String)bodyMimeType);
        FormEntryBuilder formEntryBuilder = this.getFormEntryBuilder(contentType);
        MultiValueMap<String, Object> form = this.buildForm(exchange, formData, formEntryBuilder);
        this.writeForm(exchange, contentType, form);
    }

    private MultiValueMap<String, Object> buildForm(Exchange exchange, FormData formData, FormEntryBuilder entryBuilder) throws IOException {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        for (FormEntry entry : formData.getEntries()) {
            Object formEntry = entryBuilder.build(exchange, entry);
            form.add((Object)entry.getName(), formEntry);
        }
        return form;
    }

    private FormEntryBuilder getFormEntryBuilder(MediaType formType) {
        return this.isMultipart(formType) ? this::buildHttpEntity : this::buildGenericEntity;
    }

    private boolean isMultipart(MediaType formType) {
        return formType.getType().equalsIgnoreCase("multipart");
    }

    private Object buildGenericEntity(Exchange exchange, FormEntry entry) throws IOException {
        return this.evaluate(exchange, entry.getValue());
    }

    private HttpEntity<?> buildHttpEntity(Exchange exchange, FormEntry entry) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        Object value = this.evaluate(exchange, entry.getValue());
        if (value instanceof HttpEntity) {
            headers.addAll((MultiValueMap)((HttpEntity)value).getHeaders());
        }
        headers.setContentType(entry.getMimeType());
        String fileName = String.valueOf(this.evaluate(exchange, entry.getFileName()));
        if (Strings.isNotBlank((String)fileName)) {
            headers.setContentDispositionFormData(entry.getName(), fileName);
        }
        Object body = value instanceof HttpEntity ? ((HttpEntity)value).getBody() : value;
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    private void writeForm(Exchange exchange, MediaType contentType, MultiValueMap<String, Object> form) throws IOException {
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        final HttpHeaders headers = new HttpHeaders();
        final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        converter.write(form, contentType, new HttpOutputMessage(){

            public OutputStream getBody() throws IOException {
                return outputStream;
            }

            public HttpHeaders getHeaders() {
                return headers;
            }
        });
        Message message = exchange.getMessage();
        headers.forEach((name, values) -> values.forEach(value -> message.setHeader(name, value)));
        message.setBody((Object)outputStream.toByteArray());
    }

    private Object evaluate(Exchange exchange, String expressionString) throws IOException {
        try (SimpleLanguage simpleLanguage = new SimpleLanguage();){
            simpleLanguage.setCamelContext(exchange.getContext());
            Expression expression = simpleLanguage.createExpression(expressionString);
            Object object = expression.evaluate(exchange, Object.class);
            return object;
        }
    }

    private static interface FormEntryBuilder {
        public Object build(Exchange var1, FormEntry var2) throws IOException;
    }
}

