/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.springframework.stereotype.Component;

@Component
public class HttpSenderProcessor
implements Processor {
    private static final String DEFAULT_PROTOCOL = "http";

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getMessage();
        String url = (String)message.getHeader("CamelHttpUri", String.class);
        URI uri = new URI(UnsafeUriCharactersEncoder.encode((String)url));
        url = uri.toASCIIString();
        message.setHeader("CamelHttpUri", (Object)this.fixUrlProtocol(url));
    }

    private String fixUrlProtocol(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://") ? "http://" + url : url;
    }
}

