/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import java.time.Duration;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
public class MicroserviceRestTemplateAutoConfiguration {
    public static final Duration CONSUL_REST_TEMPLATE_TIMEOUT = Duration.ofMillis(25000L);
    private final Duration defaultRestTemplateTimeout;

    @Autowired
    public MicroserviceRestTemplateAutoConfiguration(@Value(value="${qip.restclient.timeout}") long restTemplateTimeout) {
        this.defaultRestTemplateTimeout = Duration.ofMillis(restTemplateTimeout);
    }

    @Primary
    @Bean(value={"restTemplateMS"})
    @ConditionalOnMissingBean(name={"restTemplateMS"})
    public RestTemplate restTemplateMS(RestTemplateBuilder builder) {
        return builder.requestFactory(MicroserviceRestTemplateAutoConfiguration.getClientHttpRequestFactorySupplier()).setConnectTimeout(this.defaultRestTemplateTimeout).setReadTimeout(this.defaultRestTemplateTimeout).build();
    }

    @Bean(value={"consulRestTemplateMS"})
    @ConditionalOnMissingBean(name={"consulRestTemplateMS"})
    public RestTemplate consulRestTemplateMS(RestTemplateBuilder builder) {
        return builder.requestFactory(MicroserviceRestTemplateAutoConfiguration.getClientHttpRequestFactorySupplier()).setConnectTimeout(CONSUL_REST_TEMPLATE_TIMEOUT).setReadTimeout(CONSUL_REST_TEMPLATE_TIMEOUT).build();
    }

    @NotNull
    private static Supplier<ClientHttpRequestFactory> getClientHttpRequestFactorySupplier() {
        return () -> new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
    }
}

