/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.errorhandling.errorcode;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.errorhandling.ErrorEntry;

public class ErrorCodeException
extends RuntimeException {
    private final ErrorCode errorCode;
    private final String compiledMessage;
    private final String[] messageParams;
    private final Map<String, String> additionalExtraParams;

    public ErrorCodeException(ErrorCode errorCode, String ... messageParams) {
        this(errorCode, null, Collections.emptyMap(), messageParams);
    }

    public ErrorCodeException(ErrorCode errorCode, Map<String, String> additionalExtraParams) {
        this(errorCode, null, additionalExtraParams, new String[0]);
    }

    ErrorCodeException(ErrorCode errorCode, Throwable cause, Map<String, String> additionalExtraParams, String ... messageParams) {
        super(cause);
        if (errorCode == null) {
            throw new IllegalArgumentException("ErrorCode cannot be null");
        }
        this.errorCode = errorCode;
        this.compiledMessage = this.errorCode.compileMessage(messageParams);
        this.messageParams = messageParams;
        this.additionalExtraParams = additionalExtraParams;
    }

    @Override
    public String getMessage() {
        return String.format("[%s] %s", this.errorCode.getFormattedCode(), this.compiledMessage != null ? this.compiledMessage : this.errorCode.getPayload().getReason());
    }

    public ErrorEntry buildResponseObject() {
        Map<String, String> extraParams = this.buildParametersMapping();
        extraParams.putAll(this.additionalExtraParams);
        ErrorEntry err = ErrorEntry.builder().code(this.errorCode.getFormattedCode()).message(this.compiledMessage).reason(this.getErrorCode().getPayload().getReason()).extra(extraParams).build();
        err.getExtra().remove("requestId");
        return err;
    }

    private Map<String, String> buildParametersMapping() {
        List<String> extraKeys = this.errorCode.getPayload().getExtraKeys();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < extraKeys.size(); ++i) {
            if (this.messageParams.length <= i || "null".equals(this.messageParams[i])) continue;
            map.put(extraKeys.get(i), this.messageParams[i]);
        }
        return map;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getCompiledMessage() {
        return this.compiledMessage;
    }

    public String[] getMessageParams() {
        return this.messageParams;
    }

    public Map<String, String> getAdditionalExtraParams() {
        return this.additionalExtraParams;
    }
}

