/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.ExpressionContext;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import java.util.List;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.ChainedExpressionContext;
import org.qubership.integration.platform.engine.mapper.atlasmap.functions.MapBasedExpressionContext;

public class MapFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "map";
    }

    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 2) {
            String message = String.format("%s function expects 2 arguments.", this.getName());
            throw new ParseException(message);
        }
        Expression collectionExpression = args.get(0);
        Expression mapExpression = args.get(1);
        return context -> {
            Field field = collectionExpression.evaluate(context);
            List<Field> collection = FieldUtils.getCollectionElements(field);
            FieldGroup mapped = AtlasModelFactory.createFieldGroupFrom((Field)field, (boolean)true);
            mapped.setFieldType(FieldType.ANY);
            for (Field f : collection) {
                ChainedExpressionContext subContext = new ChainedExpressionContext(MapBasedExpressionContext.fromField(f, path -> FieldUtils.replacePrefix(path, f.getPath(), field.getPath())), context);
                Field result = mapExpression.evaluate((ExpressionContext)subContext);
                FieldUtils.replacePathPrefix(result, result.getPath(), f.getPath());
                mapped.getField().add(result);
            }
            return mapped;
        };
    }
}

