/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.errorhandling.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class JsonMessageValidator {
    public static final String MESSAGE_VALIDATION_ERROR = "Errors during message validation: ";
    private static final String PARSE_MESSAGE_BODY_ERROR = "Unable to parse message body";
    private static final String EMPTY_BODY_ERROR = "Message body is empty";
    private final ObjectMapper objectMapper;

    @Autowired
    public JsonMessageValidator(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void validate(String jsonMessageAsString, String jsonSchemaAsString) {
        try {
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
            JsonSchema schemaNode = factory.getSchema(jsonSchemaAsString);
            if (StringUtils.isBlank((CharSequence)jsonMessageAsString)) {
                throw new ValidationException(EMPTY_BODY_ERROR);
            }
            JsonNode messageNode = this.objectMapper.readTree(jsonMessageAsString);
            Set errors = schemaNode.validate(messageNode);
            if (!errors.isEmpty()) {
                String validationMessages = errors.stream().map(ValidationMessage::getMessage).collect(Collectors.joining(", "));
                throw new ValidationException(MESSAGE_VALIDATION_ERROR.concat(validationMessages));
            }
        }
        catch (JsonProcessingException e) {
            throw new ValidationException(PARSE_MESSAGE_BODY_ERROR);
        }
    }
}

