/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.TokenFileAuthentication;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import org.qubership.integration.platform.engine.kubernetes.KubeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KubeOperatorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KubeOperatorConfiguration.class);
    private final String uri;
    private final String namespace;
    private final String devToken;
    private final String tokenFilePath;
    private final String cert;

    @Autowired
    public KubeOperatorConfiguration(@Value(value="${kubernetes.cluster.uri}") String uri, @Value(value="${kubernetes.cluster.namespace}") String namespace, @Value(value="${kubernetes.service-account.token-file-path}") String tokenFilePath, @Value(value="${kubernetes.service-account.cert}") String cert, @Value(value="${kubernetes.cluster.token}") Optional<String> devToken) {
        this.uri = uri;
        this.namespace = namespace;
        this.tokenFilePath = tokenFilePath;
        this.devToken = devToken.orElse(null);
        this.cert = cert;
    }

    @Bean
    @ConditionalOnProperty(prefix="kubernetes", name={"devmode"}, havingValue="false", matchIfMissing=true)
    public KubeOperator kubeOperator() {
        try {
            log.info("Creating KubernetesOperator bean in PROD mode");
            ApiClient client = new ClientBuilder().setVerifyingSsl(false).setBasePath(this.uri).setCertificateAuthority(Files.readAllBytes(Paths.get(this.cert, new String[0]))).setAuthentication((Authentication)new TokenFileAuthentication(this.tokenFilePath)).build();
            return new KubeOperator(client, this.namespace, Boolean.valueOf(false));
        }
        catch (Exception e) {
            log.error("Invalid k8s cluster parameters, can't initialize k8s API. {}", (Object)e.getMessage());
            return new KubeOperator();
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="kubernetes", name={"devmode"}, havingValue="true")
    public KubeOperator kubeOperatorDev() {
        try {
            log.info("Creating KubernetesOperator bean in DEV mode");
            ApiClient client = new ClientBuilder().setVerifyingSsl(false).setBasePath(this.uri).setAuthentication((Authentication)new AccessTokenAuthentication(this.devToken)).build();
            return new KubeOperator(client, this.namespace, Boolean.valueOf(true));
        }
        catch (Exception e) {
            log.error("Invalid k8s cluster parameters, can't initialize k8s API. {}", (Object)e.getMessage());
            return new KubeOperator();
        }
    }
}

