/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnMissingBean(name={"swaggerConfiguration"})
public class SwaggerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfiguration.class);

    @Bean
    public OpenAPI getApi() {
        return new OpenAPI().addServersItem(new Server().url("/")).info(this.getInfo());
    }

    private Info getInfo() {
        return new Info().title("QIP Engine").description("REST API of QIP Engine Microservice").extensions(Map.of("x-api-kind", "no-bwc")).version("v1");
    }
}

