/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.consul;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.qubership.integration.platform.engine.events.CommonVariablesUpdatedEvent;
import org.qubership.integration.platform.engine.events.SecuredVariablesUpdatedEvent;
import org.qubership.integration.platform.engine.events.UpdateEvent;
import org.qubership.integration.platform.engine.util.DevModeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DeploymentReadinessService {
    private static final Logger log = LoggerFactory.getLogger(DeploymentReadinessService.class);
    public static final int CONSUMER_STARTUP_CHECK_DELAY_MILLIS = 20000;
    private final ConcurrentMap<Class<? extends UpdateEvent>, Boolean> receivedEvents = new ConcurrentHashMap<Class<CommonVariablesUpdatedEvent>, Boolean>(Map.of(CommonVariablesUpdatedEvent.class, false));
    private boolean readyForDeploy = false;
    private boolean initialized = false;

    @Autowired
    public DeploymentReadinessService(DevModeUtil devModeUtil) {
        if (!devModeUtil.isDevMode()) {
            this.receivedEvents.put(SecuredVariablesUpdatedEvent.class, false);
        }
    }

    @Async
    @EventListener(value={ApplicationStartedEvent.class})
    public void onApplicationStarted() {
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.isRequiredEventsReceived()) {
            Map<String, Boolean> outputMap = this.receivedEvents.entrySet().stream().collect(Collectors.toMap(entry -> ((Class)entry.getKey()).getSimpleName(), Map.Entry::getValue));
            log.error("At least one required event was not received (for this time) to start deployments processing!Events status: {}", outputMap);
        }
    }

    @EventListener
    public void onCommonVariablesUpdated(CommonVariablesUpdatedEvent event) {
        this.onUpdateEvent((UpdateEvent)event);
    }

    @EventListener
    public void onSecuredVariablesUpdated(SecuredVariablesUpdatedEvent event) {
        this.onUpdateEvent((UpdateEvent)event);
    }

    private synchronized void onUpdateEvent(UpdateEvent event) {
        if (event.isInitialUpdate()) {
            if (log.isDebugEnabled()) {
                log.debug("Initial UpdateEvent received: {}", (Object)event.getClass().getSimpleName());
            }
            this.receivedEvents.put(event.getClass(), true);
            this.checkAndStartDeploymentUpdatesConsumer();
        }
    }

    private synchronized void checkAndStartDeploymentUpdatesConsumer() {
        if (!this.readyForDeploy && this.isRequiredEventsReceived()) {
            log.info("Required events to start deployment updates consumer received successfully");
            this.readyForDeploy = true;
        }
    }

    private boolean isRequiredEventsReceived() {
        return this.receivedEvents.entrySet().stream().allMatch(Map.Entry::getValue);
    }

    public boolean isReadyForDeploy() {
        return this.readyForDeploy;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

