/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import com.rabbitmq.client.MetricsCollector;
import com.rabbitmq.client.impl.MicrometerMetricsCollector;
import io.grpc.Status;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.grpc.MetricCollectingClientInterceptor;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.MicrometerHttpClientInterceptor;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.component.kafka.DefaultKafkaClientFactory;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.qubership.integration.platform.engine.camel.components.kafka.TaggedMetricsKafkaClientFactory;
import org.qubership.integration.platform.engine.camel.components.rabbitmq.NoOpMetricsCollector;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletTagsProvider;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.testing.TestingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CamelComponentDependencyBinder {
    private static final Logger log = LoggerFactory.getLogger(CamelComponentDependencyBinder.class);
    private final ServerConfiguration serverConfiguration;
    private final MetricsStore metricsStore;
    private final Optional<TestingService> testingService;

    @Autowired
    public CamelComponentDependencyBinder(ServerConfiguration serverConfiguration, MetricsStore metricsStore, Optional<TestingService> testingService) {
        this.serverConfiguration = serverConfiguration;
        this.metricsStore = metricsStore;
        this.testingService = testingService;
    }

    public void bindToRegistry(SpringCamelContext context, DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration) {
        for (ElementProperties elementProperties : deploymentConfiguration.getProperties()) {
            String elementId = elementProperties.getElementId();
            if (CamelComponentDependencyBinder.isKafkaChainElement((ElementProperties)elementProperties)) {
                this.bindForKafka(context, deploymentInfo, elementProperties, elementId);
                continue;
            }
            if (CamelComponentDependencyBinder.isAmpqChainElement((ElementProperties)elementProperties)) {
                this.bindForRabbitMQ(context, deploymentInfo, elementProperties, elementId);
                continue;
            }
            if (CamelComponentDependencyBinder.isGrpcChainElement((ElementProperties)elementProperties)) {
                this.bindForGRPC(context, deploymentInfo, elementProperties, elementId);
                continue;
            }
            if (CamelComponentDependencyBinder.isHttpChainElement((ElementProperties)elementProperties) && !CamelComponentDependencyBinder.isHttpTriggerElement((ElementProperties)elementProperties)) {
                this.bindForHttpSender(context, deploymentInfo, elementProperties, elementId);
                continue;
            }
            if (!CamelComponentDependencyBinder.isHttpTriggerElement((ElementProperties)elementProperties)) continue;
            this.bindForHttpTrigger(context, deploymentInfo, elementProperties, elementId);
        }
    }

    private void bindForHttpTrigger(SpringCamelContext context, DeploymentInfo deploymentInfo, ElementProperties elementProperties, String elementId) {
        KeyValues tags = this.buildMetricTags(deploymentInfo, elementProperties, deploymentInfo.getChainName());
        ServletTagsProvider servletTagsProvider = new ServletTagsProvider(tags);
        context.getRegistry().bind(elementId, ServletTagsProvider.class, (Object)servletTagsProvider);
    }

    private void bindForHttpSender(SpringCamelContext context, DeploymentInfo deploymentInfo, ElementProperties elementProperties, String elementId) {
        HttpClientConfigurer httpClientConfigurer = clientBuilder -> {
            if (this.metricsStore.isMetricsEnabled()) {
                MicrometerHttpClientInterceptor interceptor = new MicrometerHttpClientInterceptor(this.metricsStore.getMeterRegistry(), request -> {
                    try {
                        return elementProperties.getProperties().get("integrationOperationPath") != null ? (String)elementProperties.getProperties().get("integrationOperationPath") : request.getUri().toString();
                    }
                    catch (URISyntaxException e) {
                        log.error("Failed to get URI from request");
                        return "";
                    }
                }, (Iterable)this.buildMetricTagsLegacy(deploymentInfo, elementProperties, deploymentInfo.getChainName()), true);
                clientBuilder.addRequestInterceptorFirst(interceptor.getRequestInterceptor());
                clientBuilder.addResponseInterceptorLast(interceptor.getResponseInterceptor());
            }
            this.testingService.ifPresent(s -> {
                if (s.canBeMocked(elementProperties)) {
                    HttpRequestInterceptor endpointMockInterceptor = s.buildEndpointMockInterceptor(deploymentInfo.getChainId(), elementProperties);
                    clientBuilder.addRequestInterceptorFirst(endpointMockInterceptor);
                    clientBuilder.setRoutePlanner(s.buildRoutePlanner(deploymentInfo.getChainId(), elementProperties));
                }
            });
            if (!Boolean.parseBoolean(elementProperties.getProperties().getOrDefault("reuseEstablishedConnection", "true"))) {
                clientBuilder.setConnectionReuseStrategy((request, response, httpContext) -> false);
            }
            clientBuilder.disableAutomaticRetries();
        };
        context.getRegistry().bind(elementId, HttpClientConfigurer.class, (Object)httpClientConfigurer);
    }

    private void bindForGRPC(SpringCamelContext context, DeploymentInfo deploymentInfo, ElementProperties elementProperties, String elementId) {
        if (this.metricsStore.isMetricsEnabled()) {
            Collection tags = this.buildMetricTagsLegacy(deploymentInfo, elementProperties, deploymentInfo.getChainName());
            UnaryOperator counterCustomizer = counter -> counter.tags(tags);
            UnaryOperator timerCustomizer = timer -> timer.tags(tags);
            MetricCollectingClientInterceptor metricInterceptor = new MetricCollectingClientInterceptor(this.metricsStore.getMeterRegistry(), counterCustomizer, timerCustomizer, new Status.Code[]{Status.Code.OK});
            context.getRegistry().bind(elementId, (Object)metricInterceptor);
        }
    }

    private void bindForRabbitMQ(SpringCamelContext context, DeploymentInfo deploymentInfo, ElementProperties elementProperties, String elementId) {
        Collection tags = this.buildMetricTagsLegacy(deploymentInfo, elementProperties, deploymentInfo.getChainName());
        String maasClassifier = (String)elementProperties.getProperties().get("maasClassifier");
        if (!StringUtils.isEmpty((CharSequence)maasClassifier)) {
            tags.add(Tag.of((String)"maas_classifier", (String)maasClassifier));
        }
        MicrometerMetricsCollector metricsCollector = this.metricsStore.isMetricsEnabled() ? new MicrometerMetricsCollector(this.metricsStore.getMeterRegistry(), "rabbitmq", (Iterable)tags) : new NoOpMetricsCollector();
        context.getRegistry().bind(elementId, MetricsCollector.class, (Object)metricsCollector);
    }

    private void bindForKafka(SpringCamelContext context, DeploymentInfo deploymentInfo, ElementProperties elementProperties, String elementId) {
        DefaultKafkaClientFactory defaultFactory = new DefaultKafkaClientFactory();
        Collection tags = this.buildMetricTagsLegacy(deploymentInfo, elementProperties, deploymentInfo.getChainName());
        String maasClassifier = (String)elementProperties.getProperties().get("maasClassifier");
        if (!StringUtils.isEmpty((CharSequence)maasClassifier)) {
            tags.add(Tag.of((String)"maas_classifier", (String)maasClassifier));
        }
        DefaultKafkaClientFactory kafkaClientFactory = this.metricsStore.isMetricsEnabled() ? new TaggedMetricsKafkaClientFactory((KafkaClientFactory)defaultFactory, this.metricsStore.getMeterRegistry(), tags) : defaultFactory;
        context.getRegistry().bind(elementId, KafkaClientFactory.class, (Object)kafkaClientFactory);
        context.getRegistry().bind(elementId + "-v2", KafkaClientFactory.class, (Object)kafkaClientFactory);
    }

    private static boolean isHttpTriggerElement(ElementProperties elementProperties) {
        String elementType = (String)elementProperties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        return ChainElementType.HTTP_TRIGGER.equals((Object)chainElementType);
    }

    private static boolean isKafkaChainElement(ElementProperties elementProperties) {
        String elementType = (String)elementProperties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        return ChainElementType.isKafkaAsyncElement((ChainElementType)chainElementType) && (!CamelComponentDependencyBinder.isServiceCallOrAsyncApiTrigger((ChainElementType)chainElementType) || "kafka".equals(elementProperties.getProperties().get("integrationOperationProtocolType")));
    }

    private static boolean isAmpqChainElement(ElementProperties elementProperties) {
        String elementType = (String)elementProperties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        return ChainElementType.isAmqpAsyncElement((ChainElementType)chainElementType) && (!CamelComponentDependencyBinder.isServiceCallOrAsyncApiTrigger((ChainElementType)chainElementType) || "amqp".equals(elementProperties.getProperties().get("integrationOperationProtocolType")));
    }

    private static boolean isHttpChainElement(ElementProperties elementProperties) {
        String elementType = (String)elementProperties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        String protocol = (String)elementProperties.getProperties().get("integrationOperationProtocolType");
        return ChainElementType.isHttpElement((ChainElementType)chainElementType) && (!ChainElementType.SERVICE_CALL.equals((Object)chainElementType) || "http".equals(protocol) || "graphql".equals(protocol));
    }

    private static boolean isGrpcChainElement(ElementProperties elementProperties) {
        String elementType = (String)elementProperties.getProperties().get("elementType");
        ChainElementType chainElementType = ChainElementType.fromString((String)elementType);
        String protocol = (String)elementProperties.getProperties().get("integrationOperationProtocolType");
        return ChainElementType.SERVICE_CALL.equals((Object)chainElementType) && "grpc".equals(protocol);
    }

    private static boolean isServiceCallOrAsyncApiTrigger(ChainElementType chainElementType) {
        return ChainElementType.SERVICE_CALL.equals((Object)chainElementType) || ChainElementType.ASYNCAPI_TRIGGER.equals((Object)chainElementType);
    }

    Collection<Tag> buildMetricTagsLegacy(DeploymentInfo deploymentInfo, ElementProperties elementProperties, String chainName) {
        return new ArrayList<Tag>(Arrays.asList(Tag.of((String)"chain_id", (String)deploymentInfo.getChainId()), Tag.of((String)"chain_name", (String)chainName), Tag.of((String)"element_id", (String)((String)elementProperties.getProperties().get("elementId"))), Tag.of((String)"element_name", (String)((String)elementProperties.getProperties().get("elementName"))), Tag.of((String)"engine_domain", (String)this.serverConfiguration.getDomain())));
    }

    KeyValues buildMetricTags(DeploymentInfo deploymentInfo, ElementProperties elementProperties, String chainName) {
        return KeyValues.of((KeyValue[])new KeyValue[]{KeyValue.of((String)"chain_id", (String)deploymentInfo.getChainId()), KeyValue.of((String)"chain_name", (String)chainName), KeyValue.of((String)"element_id", (String)((String)elementProperties.getProperties().get("elementId"))), KeyValue.of((String)"element_name", (String)((String)elementProperties.getProperties().get("elementName"))), KeyValue.of((String)"engine_domain", (String)this.serverConfiguration.getDomain())});
    }
}

