/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;

public final class ServiceVariableUtils {
    private static final ServiceVariableUtils INSTANCE = new ServiceVariableUtils();
    private List<String> serviceVariablesName = new ArrayList();

    private ServiceVariableUtils() {
        this.initServiceVariablesNames();
    }

    private void initServiceVariablesNames() {
        this.serviceVariablesName.addAll(this.getServiceVariablesName(Exchange.class));
        this.serviceVariablesName.addAll(this.getServiceVariablesName(CamelDebugger.class));
    }

    private List<String> getServiceVariablesName(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        return Arrays.stream(fields).filter(field -> {
            Class<?> type = field.getType();
            return type.equals(String.class);
        }).map(field -> {
            field.setAccessible(true);
            try {
                return (String)field.get(clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, Object> getCustomProperties(Exchange exchange) {
        Map allProperties = exchange.getProperties();
        HashMap<String, Object> mapCopy = new HashMap<String, Object>(allProperties);
        this.serviceVariablesName.forEach(mapCopy::remove);
        return mapCopy;
    }

    public List<String> getServiceVariablesName() {
        return this.serviceVariablesName;
    }
}

