/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.logging;

import com.networknt.schema.utils.StringUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.tracing.SpanAdapter;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.SessionElementProperty;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.service.ExecutionStatus;
import org.qubership.integration.platform.engine.service.debugger.logging.ChainLogger;
import org.qubership.integration.platform.engine.service.debugger.logging.OriginatingBusinessIdProvider;
import org.qubership.integration.platform.engine.service.debugger.tracing.TracingService;
import org.qubership.integration.platform.engine.service.debugger.util.DebuggerUtils;
import org.qubership.integration.platform.engine.service.debugger.util.PayloadExtractor;
import org.qubership.integration.platform.engine.util.IdentifierUtils;
import org.qubership.integration.platform.engine.util.log.ExtendedErrorLogger;
import org.qubership.integration.platform.engine.util.log.ExtendedErrorLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ChainLogger {
    private static final Logger log = LoggerFactory.getLogger(ChainLogger.class);
    private static final ExtendedErrorLogger chainLogger = ExtendedErrorLoggerFactory.getLogger(ChainLogger.class);
    public static final String MDC_TRACE_ID = "trace_id";
    public static final String MDC_SNAP_ID = "span_id";
    private final TracingService tracingService;
    private final Optional<OriginatingBusinessIdProvider> originatingBusinessIdProvider;

    @Autowired
    public ChainLogger(@Lazy TracingService tracingService, Optional<OriginatingBusinessIdProvider> originatingBusinessIdProvider) {
        this.tracingService = tracingService;
        this.originatingBusinessIdProvider = originatingBusinessIdProvider;
    }

    public static void updateMDCProperty(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    public void debug(String format, Object ... arguments) {
        chainLogger.debug(format, arguments);
    }

    public void info(String format, Object ... arguments) {
        chainLogger.info(format, arguments);
    }

    public void warn(String format, Object ... arguments) {
        chainLogger.warn(format, arguments);
    }

    public void error(String format, Object ... arguments) {
        chainLogger.error(format, arguments);
    }

    public void logBeforeProcess(Exchange exchange, CamelDebuggerProperties dbgProperties, String bodyForLogging, Map<String, String> headersForLogging, Map<String, SessionElementProperty> exchangePropertiesForLogging, String nodeId) {
        bodyForLogging = DebuggerUtils.chooseLogPayload((Exchange)exchange, (String)bodyForLogging, (CamelDebuggerProperties)dbgProperties);
        if (dbgProperties.getRuntimeProperties(exchange).getLogLoggingLevel().isInfoLevel()) {
            ChainElementType type = ChainElementType.fromString((String)((String)dbgProperties.getElementProperty(nodeId).get("elementType")));
            switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[type.ordinal()]) {
                case 1: 
                case 2: {
                    chainLogger.info("Scheduled chain trigger started");
                    break;
                }
                case 3: {
                    chainLogger.info("Scheduled SDS trigger started");
                    break;
                }
                case 4: {
                    chainLogger.info("Executing a linked chain. Headers: {}, body: {}, exchange properties: {}", new Object[]{headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    chainLogger.info("Get request from trigger. Headers: {}, body: {}, exchange properties: {}", new Object[]{headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                    break;
                }
                case 15: {
                    this.logRequest(exchange, bodyForLogging, headersForLogging, exchangePropertiesForLogging, null, null);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    chainLogger.info("Send request to queue. Headers: {}, body: {}, exchange properties: {}", new Object[]{headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                    break;
                }
                case 24: 
                case 25: {
                    break;
                }
            }
        }
    }

    public void logAfterProcess(Exchange exchange, CamelDebuggerProperties dbgProperties, String bodyForLogging, Map<String, String> headersForLogging, Map<String, SessionElementProperty> exchangePropertiesForLogging, String nodeId, long timeTaken) {
        boolean failedOperation = DebuggerUtils.isFailedOperation((Exchange)exchange);
        bodyForLogging = DebuggerUtils.chooseLogPayload((Exchange)exchange, (String)bodyForLogging, (CamelDebuggerProperties)dbgProperties);
        if (dbgProperties.getRuntimeProperties(exchange).getLogLoggingLevel().isInfoLevel() || failedOperation) {
            ChainElementType type = ChainElementType.fromString((String)((String)dbgProperties.getElementProperty(nodeId).get("elementType")));
            switch (1.$SwitchMap$org$qubership$integration$platform$engine$model$ChainElementType[type.ordinal()]) {
                case 15: 
                case 24: {
                    Map headers = exchange.getMessage().getHeaders();
                    if (failedOperation) {
                        this.setLoggerContext(exchange, dbgProperties, nodeId, this.tracingService.isTracingEnabled());
                        if (exchange.getException() instanceof CamelException) {
                            CamelException exception = (CamelException)exchange.getException(CamelException.class);
                            if (exception instanceof HttpOperationFailedException) {
                                this.logFailedHttpOperation(bodyForLogging, headersForLogging, exchangePropertiesForLogging, (HttpOperationFailedException)exception, timeTaken);
                                break;
                            }
                            Throwable[] suppressed = exception.getSuppressed();
                            if (suppressed.length <= 0) break;
                            for (Throwable ex : suppressed) {
                                if (!(ex instanceof HttpOperationFailedException)) continue;
                                this.logFailedHttpOperation(bodyForLogging, headersForLogging, exchangePropertiesForLogging, (HttpOperationFailedException)ex, timeTaken);
                            }
                            break;
                        }
                        this.logFailedOperation(bodyForLogging, headersForLogging, exchangePropertiesForLogging, exchange.getException(), timeTaken);
                        break;
                    }
                    if (!headers.containsKey("CamelHttpResponseCode")) break;
                    Integer code = PayloadExtractor.getResponseCode((Map)headers);
                    String httpUriHeader = (String)exchange.getMessage().getHeader("CamelHttpUri", String.class);
                    chainLogger.info("{} HTTP request completed. Headers: {}, body: {}, exchange properties: {}", new Object[]{this.constructExtendedHTTPLogMessage(httpUriHeader, code, Long.valueOf(timeTaken), "response"), headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    if (failedOperation) {
                        this.setLoggerContext(exchange, dbgProperties, nodeId, this.tracingService.isTracingEnabled());
                        chainLogger.error(ErrorCode.match((Throwable)exchange.getException()), "Sending message to queue failed. {} Headers: {}, body: {}, exchange properties: {}", new Object[]{exchange.getException().getMessage(), headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                        break;
                    }
                    chainLogger.info("Sending message to queue completed. Headers: {}, body: {}, exchange properties: {}", new Object[]{headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                    break;
                }
                case 26: {
                    if (((Boolean)exchange.getProperty("internalProperty_isCheckpointTriggerStep", (Object)false, Boolean.class)).booleanValue()) break;
                    chainLogger.info("Session checkpoint passed");
                    break;
                }
                default: {
                    if (!failedOperation) break;
                    this.setLoggerContext(exchange, dbgProperties, nodeId, this.tracingService.isTracingEnabled());
                    chainLogger.error(ErrorCode.match((Throwable)exchange.getException()), "Failed message: {} Headers: {}, body: {}, exchange properties: {}", new Object[]{exchange.getException().getMessage(), headersForLogging, bodyForLogging, exchangePropertiesForLogging});
                }
            }
        }
    }

    public void logExchangeFinished(CamelDebuggerProperties dbgProperties, String bodyForLogging, String headersForLogging, String exchangePropertiesForLogging, ExecutionStatus executionStatus, long duration) {
        if (dbgProperties.containsElementProperty("executionStatus")) {
            executionStatus = ExecutionStatus.computeHigherPriorityStatus((ExecutionStatus)ExecutionStatus.valueOf((String)((String)dbgProperties.getElementProperty("executionStatus").get("executionStatus"))), (ExecutionStatus)executionStatus);
        }
        chainLogger.info("Session {}. Duration {}ms. Headers: {}, body: {}, exchange properties: {}", new Object[]{ExecutionStatus.formatToLogStatus((ExecutionStatus)executionStatus), duration, headersForLogging, bodyForLogging, exchangePropertiesForLogging});
    }

    public void logHTTPExchangeFinished(Exchange exchange, CamelDebuggerProperties dbgProperties, String bodyForLogging, String headersForLogging, String exchangePropertiesForLogging, String nodeId, long timeTaken, Exception exception) {
        Map elementProperties;
        String requestUrl = (String)exchange.getProperty("internalProperty_servletRequestUrl");
        if (nodeId != null && (elementProperties = dbgProperties.getElementProperty(nodeId)) != null) {
            String elementName = (String)elementProperties.get("elementName");
            String elementId = (String)elementProperties.get("elementId");
            ChainLogger.updateMDCProperty((String)"elementId", (String)elementId);
            ChainLogger.updateMDCProperty((String)"elementName", (String)elementName);
        }
        int responseCode = PayloadExtractor.getServletResponseCode((Exchange)exchange, (Exception)exception);
        if (exception != null || !HttpUtil.isStatusCodeOk((int)responseCode, (String)"100-399")) {
            ErrorCode errorCode = exception != null ? ErrorCode.match((Throwable)exception) : (ErrorCode)exchange.getProperty("internalProperty_httpTriggerErrorCode");
            chainLogger.error(errorCode, "{} HTTP request {}. Headers: {}, body: {}, exchange properties: {}", new Object[]{this.constructExtendedHTTPLogMessage(requestUrl, Integer.valueOf(responseCode), Long.valueOf(timeTaken), "response"), "failed", headersForLogging, bodyForLogging, exchangePropertiesForLogging});
        } else {
            chainLogger.info("{} HTTP request {}. Headers: {}, body: {}, exchange properties: {}", new Object[]{this.constructExtendedHTTPLogMessage(requestUrl, Integer.valueOf(responseCode), Long.valueOf(timeTaken), "response"), "completed", headersForLogging, bodyForLogging, exchangePropertiesForLogging});
        }
    }

    public void setLoggerContext(Exchange exchange, CamelDebuggerProperties dbgProperties, @Nullable String nodeId, boolean tracingEnabled) {
        Map elementProperties;
        String chainId = dbgProperties.getDeploymentInfo().getChainId();
        String chainName = dbgProperties.getDeploymentInfo().getChainName();
        String sessionId = exchange.getProperty("internalProperty_sessionId").toString();
        String elementName = null;
        String elementId = null;
        if (nodeId != null && (elementProperties = dbgProperties.getElementProperty(nodeId = DebuggerUtils.getNodeIdFormatted((String)nodeId))) != null) {
            elementName = (String)elementProperties.get("elementName");
            elementId = (String)elementProperties.get("elementId");
        }
        ChainLogger.updateMDCProperty((String)"chainId", (String)chainId);
        ChainLogger.updateMDCProperty((String)"chainName", (String)chainName);
        ChainLogger.updateMDCProperty((String)"internalProperty_sessionId", (String)sessionId);
        ChainLogger.updateMDCProperty((String)"elementId", elementId);
        ChainLogger.updateMDCProperty((String)"elementName", (String)elementName);
        ChainLogger.updateMDCProperty((String)"logType", (String)"int");
        this.originatingBusinessIdProvider.ifPresent(businessIdProvider -> ChainLogger.updateMDCProperty((String)"originating-bi-id", (String)businessIdProvider.getOriginatingBusinessId()));
        String traceId = null;
        String spanId = null;
        SpanAdapter span = ActiveSpanManager.getSpan((Exchange)exchange);
        if (tracingEnabled && span != null) {
            traceId = span.traceId();
            spanId = span.spanId();
        }
        ChainLogger.updateMDCProperty((String)"trace_id", traceId);
        ChainLogger.updateMDCProperty((String)"span_id", spanId);
    }

    public void logRequest(Exchange exchange, String bodyForLogging, Map<String, String> headersForLogging, Map<String, SessionElementProperty> exchangePropertiesForLogging, String externalServiceName, String externalServiceEnvName) {
        String httpUriHeader = (String)exchange.getMessage().getHeader("CamelHttpUri", String.class);
        if (StringUtils.isBlank((String)externalServiceName)) {
            if (httpUriHeader != null) {
                chainLogger.info("{} Send HTTP request. Headers: {}, body: {}, exchange properties: {}", new Object[]{this.constructExtendedHTTPLogMessage(httpUriHeader, null, null, "request"), headersForLogging, bodyForLogging, exchangePropertiesForLogging});
            } else {
                chainLogger.info("Send request. Headers: {}, body: {}, exchange properties: {}", new Object[]{headersForLogging, bodyForLogging, exchangePropertiesForLogging});
            }
        } else if (httpUriHeader != null) {
            chainLogger.info("{} Send HTTP request. Headers: {}, body: {}, exchange properties: {}, external service name: {}, external service environment name: {}", new Object[]{this.constructExtendedHTTPLogMessage(httpUriHeader, null, null, "request"), headersForLogging, bodyForLogging, exchangePropertiesForLogging, externalServiceName, externalServiceEnvName});
        } else {
            chainLogger.info("Send request. Headers: {}, body: {}, exchange properties: {}, external service name: {}, external service environment name: {}", new Object[]{headersForLogging, bodyForLogging, exchangePropertiesForLogging, externalServiceName, externalServiceEnvName});
        }
    }

    public void logRequestAttempt(Exchange exchange, CamelDebuggerProperties dbgProperties, String elementId) {
        RetryParameters retryParameters = this.getRetryParameters(exchange, dbgProperties, elementId);
        chainLogger.info("Request attempt: {} (max {}).", (Object)(retryParameters.iteration + 1), (Object)(retryParameters.count + 1));
    }

    public void logRetryRequestAttempt(Exchange exchange, CamelDebuggerProperties dbgProperties, String elementId) {
        RetryParameters retryParameters = this.getRetryParameters(exchange, dbgProperties, elementId);
        if (retryParameters.enable && retryParameters.iteration > 0 && retryParameters.count > 0) {
            Throwable exception = (Throwable)exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Throwable.class);
            chainLogger.warn("Request failed and will be retried after {}ms delay (retries left: {}): {}", new Object[]{retryParameters.interval, retryParameters.count - retryParameters.iteration, Optional.ofNullable(exception).map(Throwable::getMessage).orElse("")});
        }
    }

    private RetryParameters getRetryParameters(Exchange exchange, CamelDebuggerProperties dbgProperties, String elementId) {
        try {
            Map elementProperties = Optional.ofNullable(dbgProperties.getElementProperty(elementId)).orElse(Collections.emptyMap());
            int retryCount = Integer.parseInt(elementProperties.getOrDefault("retryCount", "0"));
            int retryDelay = Integer.valueOf(elementProperties.getOrDefault("retryDelay", String.valueOf(5000)));
            String iteratorPropertyName = IdentifierUtils.getServiceCallRetryIteratorPropertyName((String)elementId);
            int iteration = Integer.parseInt(String.valueOf(exchange.getProperties().getOrDefault(iteratorPropertyName, 0)));
            String enableProperty = IdentifierUtils.getServiceCallRetryPropertyName((String)elementId);
            boolean enable = Boolean.parseBoolean(String.valueOf(exchange.getProperties().getOrDefault(enableProperty, "false")));
            return new RetryParameters(retryCount, retryDelay, iteration, enable);
        }
        catch (NumberFormatException ex) {
            chainLogger.error("Failed to get retry parameters.", (Throwable)ex);
            return new RetryParameters(0, 0, 0, false);
        }
    }

    private void logFailedHttpOperation(String bodyForLogging, Map<String, String> headersForLogging, Map<String, SessionElementProperty> exchangePropertiesForLogging, HttpOperationFailedException httpException, long duration) {
        int code = httpException.getStatusCode();
        String uri = httpException.getUri();
        chainLogger.error(ErrorCode.match((Throwable)httpException), "{} HTTP request failed. Headers: {}, body: {}, exchange properties: {}", new Object[]{this.constructExtendedHTTPLogMessage(uri, Integer.valueOf(code), Long.valueOf(duration), "response"), headersForLogging, bodyForLogging, exchangePropertiesForLogging});
    }

    private void logFailedOperation(String bodyForLogging, Map<String, String> headersForLogging, Map<String, SessionElementProperty> exchangePropertiesForLogging, Exception exception, long duration) {
        chainLogger.error(ErrorCode.match((Throwable)exception), "{} HTTP request failed. {} Headers: {}, body: {}, exchange properties: {}", new Object[]{this.constructExtendedLogMessage(Long.valueOf(duration), "response"), exception.getMessage(), headersForLogging, bodyForLogging, exchangePropertiesForLogging});
    }

    private String constructExtendedHTTPLogMessage(String targetUrl, Integer responseCode, Long responseTime, String direction) {
        String noValue = "-";
        String responseCodeStr = responseCode != null ? responseCode.toString() : noValue;
        String responseTimeStr = responseTime != null ? responseTime.toString() : noValue;
        targetUrl = targetUrl != null ? targetUrl : "";
        return String.format("[url=%-36s] [responseCode=%-3s] [responseTime=%-4s] [direction=%-8s]", targetUrl, responseCodeStr, responseTimeStr, direction);
    }

    private String constructExtendedLogMessage(Long responseTime, String direction) {
        String noValue = "-";
        String responseTimeStr = responseTime != null ? responseTime.toString() : noValue;
        return String.format("[responseTime=%-4s] [direction=%-8s]", responseTimeStr, direction);
    }
}

