/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.metrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBuilders;
import org.opensearch.client.opensearch._types.aggregations.Buckets;
import org.opensearch.client.opensearch._types.aggregations.ScriptedMetricAggregate;
import org.opensearch.client.opensearch._types.aggregations.ScriptedMetricAggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregate;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregation;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Options;
import org.opensearch.client.transport.httpclient5.HttpAsyncResponseConsumerFactory;
import org.qubership.integration.platform.engine.errorhandling.EngineRuntimeException;
import org.qubership.integration.platform.engine.model.opensearch.SessionElementElastic;
import org.qubership.integration.platform.engine.persistence.shared.entity.ChainDataAllocationSize;
import org.qubership.integration.platform.engine.persistence.shared.repository.CheckpointRepository;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

public class SessionsMetricsService {
    private static final Logger log = LoggerFactory.getLogger(SessionsMetricsService.class);
    private static final long SCHEDULER_INTERVAL = 60000L;
    private static final String UNABLE_TO_RETRIEVE_SESSION_METRICS_ERROR_MESSAGE = "Unable to retrieve session metrics from opensearch";
    private static final String UNABLE_TO_RETRIEVE_CHECKPOINTS_METRICS_ERROR_MESSAGE = "Unable to retrieve checkpoints metrics from postgres";
    @Value(value="${qip.opensearch.index.elements.name}")
    private String indexName;
    private final MetricsStore metricsStore;
    private final OpenSearchClient opensearchClient;
    private final Function<String, String> openSearchEntityNameNormalizer;
    private final HttpAsyncResponseConsumerFactory consumerFactory;
    private final CheckpointRepository checkpointRepository;

    public SessionsMetricsService(MetricsStore metricsStore, OpenSearchClient opensearchClient, Function<String, String> openSearchEntityNameNormalizer, CheckpointRepository checkpointRepository) {
        this.metricsStore = metricsStore;
        this.opensearchClient = opensearchClient;
        this.openSearchEntityNameNormalizer = openSearchEntityNameNormalizer;
        this.checkpointRepository = checkpointRepository;
        this.consumerFactory = HttpAsyncResponseConsumerFactory.DEFAULT;
    }

    @Scheduled(fixedDelay=60000L)
    public void processSessionsSizeMetrics() {
        ScriptedMetricAggregation sizeMetricAgg = AggregationBuilders.scriptedMetric().initScript((Script)new Script.Builder().inline(new InlineScript.Builder().lang("painless").source("state.docSizes = []").build()).build()).mapScript((Script)new Script.Builder().inline(new InlineScript.Builder().lang("painless").source("state.docSizes.add(doc.toString().length())").build()).build()).combineScript((Script)new Script.Builder().inline(new InlineScript.Builder().lang("painless").source("return state.docSizes").build()).build()).reduceScript((Script)new Script.Builder().inline(new InlineScript.Builder().lang("painless").source("def totalSize = 0; for (state in states) { for (size in state) { totalSize += size } } return totalSize").build()).build()).build();
        TopHitsAggregation chainNameAgg = AggregationBuilders.topHits().size(Integer.valueOf(1)).source(s -> s.filter(f -> f.includes("chainName", new String[0]))).build();
        TermsAggregation sessionCountAgg = AggregationBuilders.terms().field("chainId").size(Integer.valueOf(1000)).build();
        Aggregation aggregation = new Aggregation.Builder().terms(sessionCountAgg).aggregations(Map.of("calculate_all_fields_size_bytes", sizeMetricAgg._toAggregation(), "chain_name", chainNameAgg._toAggregation())).build();
        SearchRequest searchRequest = new SearchRequest.Builder().index((String)this.openSearchEntityNameNormalizer.apply(this.indexName.concat("-session-elements")), new String[0]).aggregations(Map.of("session_count", aggregation)).size(Integer.valueOf(0)).build();
        try {
            ApacheHttpClient5Options.Builder optionsBuilder = ApacheHttpClient5Options.DEFAULT.toBuilder();
            optionsBuilder.setHttpAsyncResponseConsumerFactory(this.consumerFactory);
            SearchResponse response = this.opensearchClient.withTransportOptions((TransportOptions)optionsBuilder.build()).search(searchRequest, SessionElementElastic.class);
            StringTermsAggregate responseSessionCountAgg = ((Aggregate)response.aggregations().get("session_count")).sterms();
            Buckets buckets = responseSessionCountAgg.buckets();
            Collection<Object> bucketsList = buckets.isArray() ? buckets.array() : buckets.keyed().values();
            ArrayList<ChainDataAllocationSize> chainSessionsSizes = new ArrayList<ChainDataAllocationSize>();
            for (StringTermsBucket stringTermsBucket : bucketsList) {
                String chainId = stringTermsBucket.key();
                TopHitsAggregate topHitsAgg = ((Aggregate)stringTermsBucket.aggregations().get("chain_name")).topHits();
                List hits = topHitsAgg.hits().hits();
                String chainName = !hits.isEmpty() ? ((Map)((JsonData)((Hit)hits.getFirst()).source()).to(Map.class)).get("chainName").toString() : null;
                ScriptedMetricAggregate sizeMetric = ((Aggregate)stringTermsBucket.aggregations().get("calculate_all_fields_size_bytes")).scriptedMetric();
                Long sessionsSize = (Long)sizeMetric.value().to(Long.class);
                ChainDataAllocationSize chainSessionsSize = ChainDataAllocationSize.builder().chainId(chainId).chainName(chainName).allocatedSize(sessionsSize.longValue()).build();
                chainSessionsSizes.add(chainSessionsSize);
            }
            this.metricsStore.processChainSessionsSize(chainSessionsSizes);
        }
        catch (IOException e) {
            throw new EngineRuntimeException(UNABLE_TO_RETRIEVE_SESSION_METRICS_ERROR_MESSAGE, (Exception)e);
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void processCheckpointSizeMetrics() {
        try {
            ArrayList chainCheckpointSizes = new ArrayList();
            List checkpointSizeResult = this.checkpointRepository.findAllChainCheckpointSize();
            checkpointSizeResult.forEach(row -> {
                ChainDataAllocationSize chainCheckpointSize = ChainDataAllocationSize.builder().chainId((String)row[0]).chainName((String)row[1]).allocatedSize(Long.parseLong(row[2].toString())).build();
                chainCheckpointSizes.add(chainCheckpointSize);
            });
            this.metricsStore.processChainCheckpointsSize(chainCheckpointSizes);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(UNABLE_TO_RETRIEVE_CHECKPOINTS_METRICS_ERROR_MESSAGE, e);
        }
    }
}

