/*
 * Copyright 2024-2025 NetCracker Technology Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.qubership.integration.platform.engine.configuration;


import org.qubership.integration.platform.engine.persistence.shared.repository.CheckpointRepository;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.debugger.metrics.SessionsMetricsService;
import java.util.function.Function;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableScheduling
public class SessionsMetricsServiceConfiguration {

    @Bean
    @ConditionalOnProperty(value = "qip.metrics.enabled", havingValue = "true")
    public SessionsMetricsService getMetricsService(MetricsStore metricsStore,
                                                    OpenSearchClient opensearchClient,
                                                    Function<String, String> openSearchEntityNameNormalizer,
                                                    CheckpointRepository checkpointRepository) {

        return new SessionsMetricsService(metricsStore, opensearchClient, openSearchEntityNameNormalizer, checkpointRepository);
    }
}
