/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.components.servlet.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.Exchange;
import org.apache.camel.http.base.HttpOperationFailedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.qubership.integration.platform.engine.camel.components.directvm.ChainConsumerNotAvailableException;
import org.qubership.integration.platform.engine.camel.components.servlet.exception.annotations.ChainExceptionHandler;
import org.qubership.integration.platform.engine.camel.exceptions.IterationLimitException;
import org.qubership.integration.platform.engine.errorhandling.ResponseValidationException;
import org.qubership.integration.platform.engine.errorhandling.ValidationException;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCodeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ChainGlobalExceptionHandler {
    private final ObjectMapper jsonMapper;

    @Autowired
    public ChainGlobalExceptionHandler(@Qualifier(value="jsonMapper") ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @ChainExceptionHandler(errorCode=ErrorCode.UNEXPECTED_BUSINESS_ERROR)
    public void handleGeneralException(Throwable exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={ValidationException.class}, errorCode=ErrorCode.REQUEST_VALIDATION_ERROR)
    public void handleException(ValidationException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        extraParameters.put("validationResult", exception.getMessage());
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={ResponseValidationException.class}, errorCode=ErrorCode.RESPONSE_VALIDATION_ERROR)
    public void handleException(ResponseValidationException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        extraParameters.put("validationResult", exception.getMessage());
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={CamelAuthorizationException.class}, errorCode=ErrorCode.AUTHORIZATION_ERROR)
    public void handleException(CamelAuthorizationException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={ChainConsumerNotAvailableException.class}, errorCode=ErrorCode.CHAIN_ENDPOINT_NOT_FOUND)
    public void handleChainCallException(ChainConsumerNotAvailableException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={UnknownHostException.class}, errorCode=ErrorCode.REQUESTED_ENDPOINT_NOT_FOUND)
    public void handleException(UnknownHostException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={HttpOperationFailedException.class}, errorCode=ErrorCode.SERVICE_RETURNED_ERROR)
    public void handleException(HttpOperationFailedException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        if (exception.getHttpResponseCode() == 504) {
            this.handleTimeoutException((Exception)exception, exchange, ErrorCode.SOCKET_TIMEOUT, extraParameters);
            return;
        }
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={SocketTimeoutException.class}, errorCode=ErrorCode.SOCKET_TIMEOUT)
    public void handleTimeoutException(Exception exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={TimeoutException.class}, errorCode=ErrorCode.KAFKA_TIMEOUT)
    public void handleException(TimeoutException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    @ChainExceptionHandler(value={IterationLimitException.class}, errorCode=ErrorCode.LOOP_ITERATIONS_LIMIT_REACHED)
    public void handleException(IterationLimitException exception, Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        this.makeExceptionResponseInExchange(exchange, errorCode, extraParameters);
    }

    private void makeExceptionResponseInExchange(Exchange exchange, ErrorCode errorCode, Map<String, String> extraParameters) throws IOException {
        exchange.getMessage().removeHeaders("*");
        exchange.getMessage().setHeader("Content-Type", (Object)"application/json");
        exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)errorCode.getHttpErrorCode());
        ErrorCodeException codeException = new ErrorCodeException(errorCode, extraParameters);
        exchange.getMessage().setBody((Object)this.jsonMapper.writeValueAsString((Object)codeException.buildResponseObject()));
    }
}

