/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ContentTypeMatcherProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(ContentTypeMatcherProcessor.class);
    private static final String CONTENT_TYPE_DOES_NOT_MATCH_ERROR_MESSAGE = "Expected content type {} does not match actual content type {}. ";
    private static final String DIFFERENT_LENGTH = "Expected content type {} does not match actual content type {}. Reason: Different length.";
    private static final String DIFFERENT_TYPE = "Expected content type {} does not match actual content type {}. Reason: Different MIME types.";
    private static final String DIFFERENT_DIRECTIVES = "Expected content type {} does not match actual content type {}. Reason: Different secondary directives.";
    private static final String CONTENT_TYPE_ANY = "*/*";

    public void process(Exchange exchange) throws Exception {
        String expectedContentType = (String)exchange.getProperty("internalProperty_expectedContentType", String.class);
        String actualContentType = (String)exchange.getMessage().getHeader("Content-Type", String.class);
        exchange.setProperty("internalProperty_contentTypeMatched", (Object)this.isMatched(expectedContentType, actualContentType));
    }

    private boolean isMatched(String expectedContentType, String actualContentType) {
        String[] actualContentTypesComponents;
        boolean contentTypeMatched = false;
        if (expectedContentType.equals(CONTENT_TYPE_ANY)) {
            return true;
        }
        if (actualContentType == null) {
            log.error(DIFFERENT_TYPE, (Object)expectedContentType, (Object)actualContentType);
            return contentTypeMatched;
        }
        if (expectedContentType.length() != actualContentType.length()) {
            log.error(DIFFERENT_LENGTH, (Object)expectedContentType, (Object)actualContentType);
            return contentTypeMatched;
        }
        String[] expectedContentTypesComponents = expectedContentType.split(";");
        if (!expectedContentTypesComponents[0].equals((actualContentTypesComponents = actualContentType.split(";"))[0])) {
            log.error(DIFFERENT_TYPE, (Object)expectedContentType, (Object)actualContentType);
            return contentTypeMatched;
        }
        ArrayList<String> intersectionList = new ArrayList<String>(Arrays.asList(expectedContentTypesComponents));
        intersectionList.retainAll(Arrays.asList(actualContentTypesComponents));
        boolean bl = contentTypeMatched = intersectionList.size() == expectedContentTypesComponents.length;
        if (!contentTypeMatched) {
            log.error(DIFFERENT_DIRECTIVES, (Object)expectedContentType, (Object)actualContentType);
        }
        return contentTypeMatched;
    }
}

