/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CorrelationIdPropagationProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(CorrelationIdPropagationProcessor.class);
    private final ObjectMapper objectMapper;

    @Autowired
    public CorrelationIdPropagationProcessor(@Qualifier(value="jsonMapper") ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void process(Exchange exchange) {
        String correlationId = (String)exchange.getProperty("correlationId", String.class);
        if (correlationId != null && !correlationId.equals("null")) {
            String correlationIdPosition = (String)exchange.getProperty("correlationIdPosition", String.class);
            String correlationIdName = (String)exchange.getProperty("correlationIdName", String.class);
            if ("Header".equals(correlationIdPosition)) {
                exchange.getMessage().setHeader(correlationIdName, (Object)correlationId);
            } else if ("Body".equals(correlationIdPosition)) {
                try {
                    Map body = (Map)this.objectMapper.readValue((String)exchange.getMessage().getBody(String.class), HashMap.class);
                    body.put(correlationIdName, correlationId);
                    exchange.getMessage().setBody((Object)this.objectMapper.writeValueAsString((Object)body));
                }
                catch (JsonProcessingException e) {
                    log.error("Error while adding correlationId {} to body", (Object)correlationId);
                }
            }
        }
    }
}

