/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HeaderModificationProcessor
implements Processor {
    private final SimpleLanguage simpleInterpreter;

    @Autowired
    public HeaderModificationProcessor(SimpleLanguage simpleInterpreter) {
        this.simpleInterpreter = simpleInterpreter;
    }

    public void process(Exchange exchange) throws Exception {
        Map headersToAdd = (Map)exchange.getProperty("internalProperty_headerModificationToAdd", Map.class);
        List headerPatternsToRemove = (List)exchange.getProperty("internalProperty_headerModificationToRemove", List.class);
        String[] headersToKeep = new String[]{};
        if (headersToAdd != null) {
            for (Map.Entry entry : headersToAdd.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                exchange.getMessage().setHeader((String)entry.getKey(), (Object)this.evaluateSimpleExpression(exchange, (String)entry.getValue()));
            }
            headersToKeep = headersToAdd.keySet().toArray(new String[0]);
        }
        if (headerPatternsToRemove != null) {
            for (String pattern : headerPatternsToRemove) {
                exchange.getMessage().removeHeaders(pattern, headersToKeep);
            }
        }
    }

    private String evaluateSimpleExpression(Exchange exchange, String str) {
        return (String)this.simpleInterpreter.createExpression(str).evaluate(exchange, String.class);
    }
}

