/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.camel.processors;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.JsonMessageValidator;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.util.ExchangeUtils;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RabbitMqTriggerProcessor
implements Processor {
    private final JsonMessageValidator validator;

    @Autowired
    public RabbitMqTriggerProcessor(JsonMessageValidator jsonMessageValidator) {
        this.validator = jsonMessageValidator;
    }

    public void process(Exchange exchange) throws Exception {
        this.immediateAck(exchange);
        this.validate(exchange);
    }

    private void immediateAck(Exchange exchange) throws IOException {
        AcknowledgeMode ackMode;
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)exchange.getProperty("internalProperty_acknowledgeMode", String.class))) && (ackMode = (AcknowledgeMode)exchange.getProperty("internalProperty_acknowledgeMode", (Object)AcknowledgeMode.AUTO, AcknowledgeMode.class)) == AcknowledgeMode.MANUAL) {
            Channel channel = (Channel)exchange.getProperty("CamelSpringRabbitmqChannel", Channel.class);
            long deliveryTag = (Long)exchange.getMessage().getHeader("CamelSpringRabbitmqDeliveryTag", Long.TYPE);
            channel.basicAck(deliveryTag, false);
        }
    }

    private void validate(Exchange exchange) throws IOException {
        String asyncValidationSchema = (String)exchange.getProperty("internalProperty_asyncValidationSchema");
        ExchangeUtils.setContentTypeIfMissing(exchange);
        if (asyncValidationSchema != null && !asyncValidationSchema.isEmpty()) {
            String inputJsonMessage = MessageHelper.extractBody(exchange);
            this.validator.validate(inputJsonMessage, asyncValidationSchema);
        }
    }
}

