/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.camel;

import java.util.Collections;
import java.util.List;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.spi.Policy;
import org.qubership.integration.platform.engine.security.ExchangeRolesVoter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;

@AutoConfiguration
public class CamelSecurityConfiguration {
    private static Policy buildNoOpPolicy() {
        return new Policy(){

            public void beforeWrap(Route route, NamedNode definition) {
            }

            public Processor wrap(Route route, Processor processor) {
                return processor;
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(name={"abacPolicy"})
    public Policy abacPolicy() {
        return CamelSecurityConfiguration.buildNoOpPolicy();
    }

    @Bean
    @ConditionalOnMissingBean(name={"rbacPolicy"})
    public Policy rbacPolicy() {
        return CamelSecurityConfiguration.buildNoOpPolicy();
    }

    @Bean
    public RoleVoter roleVoter(@Value(value="${security.rolePrefix:}") String rolePrefix) {
        RoleVoter voter = new RoleVoter();
        voter.setRolePrefix(rolePrefix);
        return voter;
    }

    @Bean
    public AccessDecisionManager exchangeRbacAccessDecisionManager(ExchangeRolesVoter exchangeRolesVoter) {
        List<ExchangeRolesVoter> decisionVoters = Collections.singletonList(exchangeRolesVoter);
        AffirmativeBased accessDecisionManager = new AffirmativeBased(decisionVoters);
        accessDecisionManager.setAllowIfAllAbstainDecisions(true);
        return accessDecisionManager;
    }
}

