/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.configuration.camel;

import jakarta.servlet.Servlet;
import java.util.Optional;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.qubership.integration.platform.engine.camel.components.context.propagation.ContextPropsProvider;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletCustomComponent;
import org.qubership.integration.platform.engine.camel.components.servlet.ServletCustomFilterStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CamelServletConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CamelServletConfiguration.class);
    public static final String CAMEL_SERVLET_NAME = "CamelServlet";
    public static final String CAMEL_ROUTES_PREFIX = "/routes";
    private static final String CAMEL_SERVLET_MAPPING = "/routes/*";

    @Bean
    public ServletRegistrationBean<Servlet> camelServlet() {
        if (log.isDebugEnabled()) {
            log.debug("Registration of camel servlet");
        }
        ServletRegistrationBean mapping = new ServletRegistrationBean();
        mapping.setName(CAMEL_SERVLET_NAME);
        mapping.addUrlMappings(new String[]{CAMEL_SERVLET_MAPPING});
        mapping.setServlet((Servlet)new CamelHttpTransportServlet());
        return mapping;
    }

    @Bean
    public TomcatConnectorCustomizer connectorCustomizer() {
        return connector -> connector.setEncodedSolidusHandling(EncodedSolidusHandling.PASS_THROUGH.getValue());
    }

    @Bean
    public ComponentCustomizer servletCustomComponentCustomizer(Optional<ContextPropsProvider> contextPropsProvider) {
        return ComponentCustomizer.builder(ServletCustomComponent.class).build(component -> component.setHeaderFilterStrategy((HeaderFilterStrategy)new ServletCustomFilterStrategy(contextPropsProvider)));
    }
}

