/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.api.AtlasContextFactory;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CopyTo;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Mapping;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.integration.platform.engine.mapper.atlasmap.expressions.CustomAtlasExpressionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAtlasContext
extends DefaultAtlasContext {
    private static final Logger log = LoggerFactory.getLogger(CustomAtlasContext.class);

    public CustomAtlasContext(URI atlasMappingUri) {
        super(atlasMappingUri);
    }

    public CustomAtlasContext(DefaultAtlasContextFactory factory, URI atlasMappingUri) {
        super(factory, atlasMappingUri);
    }

    public CustomAtlasContext(DefaultAtlasContextFactory factory, AtlasMapping mapping) {
        super(factory, mapping);
    }

    public CustomAtlasContext(DefaultAtlasContextFactory factory, AtlasContextFactory.Format format, InputStream stream) throws AtlasException {
        super(factory, format, stream);
    }

    protected void processSourceFieldMapping(DefaultAtlasSession session) {
        block10: {
            try {
                Mapping mapping = session.head().getMapping();
                if (mapping.getInputFieldGroup() != null) {
                    if (mapping.getExpression() != null) {
                        session.head().setSourceField((io.atlasmap.v2.Field)mapping.getInputFieldGroup());
                        CustomAtlasExpressionProcessor.processExpression(session, mapping.getExpression());
                    } else {
                        this.processSourceFieldGroup(session, mapping.getInputFieldGroup());
                    }
                } else if (mapping.getInputField() != null && !mapping.getInputField().isEmpty()) {
                    if (mapping.getExpression() != null) {
                        FieldGroup sourceFieldGroup = new FieldGroup();
                        sourceFieldGroup.getField().addAll(mapping.getInputField());
                        session.head().setSourceField((io.atlasmap.v2.Field)sourceFieldGroup);
                        CustomAtlasExpressionProcessor.processExpression(session, mapping.getExpression());
                    } else {
                        List sourceFields = mapping.getInputField();
                        this.applyCopyToActions(sourceFields, mapping);
                        this.processSourceFields(session, sourceFields);
                    }
                } else {
                    session.head().addAudit(AuditStatus.WARN, null, String.format("Mapping does not contain expression or at least one source field: alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()));
                }
            }
            catch (Exception t) {
                io.atlasmap.v2.Field sourceField = session.head().getSourceField();
                String docId = sourceField != null ? sourceField.getDocId() : null;
                String path = sourceField != null ? sourceField.getPath() : null;
                session.head().addAudit(AuditStatus.ERROR, sourceField, String.format("Unexpected exception is thrown while reading source field: %s", t.getMessage()));
                if (!log.isDebugEnabled()) break block10;
                log.error("", (Throwable)t);
            }
        }
    }

    public AtlasSession createSession() throws AtlasException {
        AtlasSession session = super.createSession();
        this.overrideDefaultDocumentId(session);
        return session;
    }

    private void overrideDefaultDocumentId(AtlasSession session) {
        try {
            Field f1 = session.getClass().getDeclaredField("defaultTargetDocumentId");
            f1.setAccessible(true);
            f1.set(session, "");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            log.error("Failed to override AtlasMap default document ID.", (Throwable)exception);
        }
    }

    private void processSourceFieldGroup(DefaultAtlasSession session, FieldGroup sourceFieldGroup) throws AtlasException {
        this.processSourceFields(session, sourceFieldGroup.getField());
        session.head().setSourceField((io.atlasmap.v2.Field)sourceFieldGroup);
        io.atlasmap.v2.Field processed = this.applyFieldActions(session, session.head().getSourceField());
        session.head().setSourceField(processed);
    }

    private void applyCopyToActions(List<io.atlasmap.v2.Field> sourceFields, Mapping mapping) {
        for (io.atlasmap.v2.Field sourceField : sourceFields) {
            if (sourceField instanceof FieldGroup) {
                this.applyCopyToActions(((FieldGroup)sourceField).getField(), mapping);
                continue;
            }
            if (sourceField.getActions() == null) continue;
            List copyTos = sourceField.getActions().stream().filter(a -> a instanceof CopyTo).map(a -> (CopyTo)a).collect(Collectors.toList());
            if (copyTos.size() == 0) {
                return;
            }
            if (copyTos.stream().flatMap(c -> c.getIndexes().stream().filter(i -> i < 0)).count() > 0L) {
                throw new IllegalArgumentException("Indexes must be >= 0");
            }
            for (CopyTo copyTo : copyTos) {
                for (io.atlasmap.v2.Field field : mapping.getOutputField()) {
                    AtlasPath path = new AtlasPath(field.getPath());
                    List segments = path.getCollectionSegments(true);
                    for (int i = 0; i < copyTo.getIndexes().size(); ++i) {
                        if (i >= segments.size()) continue;
                        path.setCollectionIndex(i + 1, (Integer)copyTo.getIndexes().get(i));
                    }
                    field.setPath(path.toString());
                }
                sourceField.getActions().remove(copyTo);
            }
        }
    }

    private void processSourceFields(DefaultAtlasSession session, List<io.atlasmap.v2.Field> sourceFields) throws AtlasException {
        for (int i = 0; i < sourceFields.size(); ++i) {
            io.atlasmap.v2.Field sourceField = sourceFields.get(i);
            session.head().setSourceField(sourceField);
            if (sourceField instanceof FieldGroup) {
                this.processSourceFields(session, ((FieldGroup)sourceField).getField());
                io.atlasmap.v2.Field processed = this.applyFieldActions(session, sourceField);
                session.head().setSourceField(processed);
                continue;
            }
            AtlasModule module = this.resolveModule(FieldDirection.SOURCE, sourceField);
            if (module == null) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (io.atlasmap.v2.Field)sourceField, (String)String.format("Module not found for docId '%s'", sourceField.getDocId()), (AuditStatus)AuditStatus.ERROR, null);
                return;
            }
            if (!module.isSupportedField(sourceField).booleanValue()) {
                AtlasUtil.addAudit((AtlasInternalSession)session, (io.atlasmap.v2.Field)sourceField, (String)String.format("Unsupported source field type '%s' for DataSource '%s'", sourceField.getClass().getName(), module.getUri()), (AuditStatus)AuditStatus.ERROR, null);
                return;
            }
            module.readSourceValue((AtlasInternalSession)session);
            io.atlasmap.v2.Field processed = this.applyFieldActions(session, session.head().getSourceField());
            session.head().setSourceField(processed);
            sourceFields.set(i, processed);
        }
    }
}

