/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap;

import io.atlasmap.api.AtlasSession;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.qubership.integration.platform.engine.mapper.atlasmap.TimestampGenerator;

public class ValueGeneratorFactory {
    Function<AtlasSession, String> getValueGenerator(String name, List<String> parameters) throws Exception {
        if (Objects.isNull(name)) {
            throw new Exception("Value generator name is null");
        }
        return switch (name) {
            case "generateUUID" -> session -> UUID.randomUUID().toString();
            case "currentDate", "currentTime", "currentDateTime" -> TimestampGenerator.fromParameterList(parameters);
            default -> throw new Exception("Unsupported value generator: " + name);
        };
    }
}

