/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.mapper.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.qubership.integration.platform.engine.mapper.atlasmap.FieldUtils;

public class ListFunctionFactory
extends BaseFunctionFactory {
    public String getName() {
        return "list";
    }

    public Expression create(List<Expression> args) throws ParseException {
        return ctx -> {
            FieldGroup group = new FieldGroup();
            group.setName("result");
            group.setPath("/result<>");
            group.setCollectionType(CollectionType.LIST);
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Expression expr : args) {
                Field value = expr.evaluate(ctx);
                if (value instanceof FieldGroup) {
                    FieldGroup fg = (FieldGroup)value;
                    fields.addAll(fg.getField());
                    continue;
                }
                fields.add(value);
            }
            int index = 0;
            for (Field field : fields) {
                Field f = null;
                if (Objects.nonNull(field)) {
                    f = FieldUtils.cloneField(field);
                    FieldUtils.replacePathSegments(f, new AtlasPath(f.getPath()).getSegments(true), new AtlasPath(String.format("/result<%d>", index)).getSegments(true));
                }
                ++index;
                group.getField().add(f);
            }
            return group;
        };
    }
}

