/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.model.deployment.properties;

import java.util.Objects;
import java.util.Set;
import org.apache.camel.Exchange;
import org.qubership.integration.platform.engine.model.logging.LogLoggingLevel;
import org.qubership.integration.platform.engine.model.logging.LogPayload;
import org.qubership.integration.platform.engine.model.logging.SessionsLoggingLevel;

public class DeploymentRuntimeProperties {
    private static final DeploymentRuntimeProperties DEFAULT_VALUES = DeploymentRuntimeProperties.builder().sessionsLoggingLevel(SessionsLoggingLevel.OFF).logLoggingLevel(LogLoggingLevel.ERROR).logPayload(Set.of(LogPayload.HEADERS, LogPayload.PROPERTIES)).dptEventsEnabled(false).maskingEnabled(true).build();
    private SessionsLoggingLevel sessionsLoggingLevel;
    private LogLoggingLevel logLoggingLevel;
    @Deprecated
    private boolean logPayloadEnabled;
    private Set<LogPayload> logPayload;
    private boolean dptEventsEnabled;
    private boolean maskingEnabled;

    public SessionsLoggingLevel calculateSessionLevel(Exchange exchange) {
        boolean isFullReportingSet;
        Boolean headerValue = (Boolean)exchange.getMessage().getHeader("TraceMe", (Object)Boolean.FALSE, Boolean.class);
        Boolean propertyValue = (Boolean)exchange.getProperty("TraceMe", (Object)headerValue, Boolean.class);
        boolean bl = isFullReportingSet = Objects.nonNull(propertyValue) && propertyValue != false;
        if (isFullReportingSet) {
            return SessionsLoggingLevel.DEBUG;
        }
        return this.sessionsLoggingLevel;
    }

    public LogLoggingLevel getLogLoggingLevel() {
        return this.logLoggingLevel == null ? LogLoggingLevel.defaultLevel() : this.logLoggingLevel;
    }

    public static DeploymentRuntimeProperties getDefaultValues() {
        return DEFAULT_VALUES;
    }

    public static DeploymentRuntimePropertiesBuilder builder() {
        return new DeploymentRuntimePropertiesBuilder();
    }

    @Deprecated
    public boolean isLogPayloadEnabled() {
        return this.logPayloadEnabled;
    }

    public Set<LogPayload> getLogPayload() {
        return this.logPayload;
    }

    public boolean isDptEventsEnabled() {
        return this.dptEventsEnabled;
    }

    public boolean isMaskingEnabled() {
        return this.maskingEnabled;
    }

    public void setSessionsLoggingLevel(SessionsLoggingLevel sessionsLoggingLevel) {
        this.sessionsLoggingLevel = sessionsLoggingLevel;
    }

    public void setLogLoggingLevel(LogLoggingLevel logLoggingLevel) {
        this.logLoggingLevel = logLoggingLevel;
    }

    @Deprecated
    public void setLogPayloadEnabled(boolean logPayloadEnabled) {
        this.logPayloadEnabled = logPayloadEnabled;
    }

    public void setLogPayload(Set<LogPayload> logPayload) {
        this.logPayload = logPayload;
    }

    public void setDptEventsEnabled(boolean dptEventsEnabled) {
        this.dptEventsEnabled = dptEventsEnabled;
    }

    public void setMaskingEnabled(boolean maskingEnabled) {
        this.maskingEnabled = maskingEnabled;
    }

    public DeploymentRuntimeProperties(SessionsLoggingLevel sessionsLoggingLevel, LogLoggingLevel logLoggingLevel, boolean logPayloadEnabled, Set<LogPayload> logPayload, boolean dptEventsEnabled, boolean maskingEnabled) {
        this.sessionsLoggingLevel = sessionsLoggingLevel;
        this.logLoggingLevel = logLoggingLevel;
        this.logPayloadEnabled = logPayloadEnabled;
        this.logPayload = logPayload;
        this.dptEventsEnabled = dptEventsEnabled;
        this.maskingEnabled = maskingEnabled;
    }

    public DeploymentRuntimeProperties() {
    }

    private SessionsLoggingLevel getSessionsLoggingLevel() {
        return this.sessionsLoggingLevel;
    }

    public static class DeploymentRuntimePropertiesBuilder {
        private SessionsLoggingLevel sessionsLoggingLevel;
        private LogLoggingLevel logLoggingLevel;
        private boolean logPayloadEnabled;
        private Set<LogPayload> logPayload;
        private boolean dptEventsEnabled;
        private boolean maskingEnabled;

        DeploymentRuntimePropertiesBuilder() {
        }

        public DeploymentRuntimePropertiesBuilder sessionsLoggingLevel(SessionsLoggingLevel sessionsLoggingLevel) {
            this.sessionsLoggingLevel = sessionsLoggingLevel;
            return this;
        }

        public DeploymentRuntimePropertiesBuilder logLoggingLevel(LogLoggingLevel logLoggingLevel) {
            this.logLoggingLevel = logLoggingLevel;
            return this;
        }

        @Deprecated
        public DeploymentRuntimePropertiesBuilder logPayloadEnabled(boolean logPayloadEnabled) {
            this.logPayloadEnabled = logPayloadEnabled;
            return this;
        }

        public DeploymentRuntimePropertiesBuilder logPayload(Set<LogPayload> logPayload) {
            this.logPayload = logPayload;
            return this;
        }

        public DeploymentRuntimePropertiesBuilder dptEventsEnabled(boolean dptEventsEnabled) {
            this.dptEventsEnabled = dptEventsEnabled;
            return this;
        }

        public DeploymentRuntimePropertiesBuilder maskingEnabled(boolean maskingEnabled) {
            this.maskingEnabled = maskingEnabled;
            return this;
        }

        public DeploymentRuntimeProperties build() {
            return new DeploymentRuntimeProperties(this.sessionsLoggingLevel, this.logLoggingLevel, this.logPayloadEnabled, this.logPayload, this.dptEventsEnabled, this.maskingEnabled);
        }

        public String toString() {
            return "DeploymentRuntimeProperties.DeploymentRuntimePropertiesBuilder(sessionsLoggingLevel=" + String.valueOf((Object)this.sessionsLoggingLevel) + ", logLoggingLevel=" + String.valueOf((Object)this.logLoggingLevel) + ", logPayloadEnabled=" + this.logPayloadEnabled + ", logPayload=" + String.valueOf(this.logPayload) + ", dptEventsEnabled=" + this.dptEventsEnabled + ", maskingEnabled=" + this.maskingEnabled + ")";
        }
    }
}

