/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.persistence.shared.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import java.util.Arrays;
import java.util.UUID;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;

@Entity(name="properties")
public class Property {
    @Id
    private String id;
    private String name;
    private String type;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] value;
    @ManyToOne(fetch=FetchType.EAGER)
    private Checkpoint checkpoint;

    private static String $default$id() {
        return UUID.randomUUID().toString();
    }

    public static PropertyBuilder builder() {
        return new PropertyBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getValue() {
        return this.value;
    }

    public Checkpoint getCheckpoint() {
        return this.checkpoint;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setCheckpoint(Checkpoint checkpoint) {
        this.checkpoint = checkpoint;
    }

    public Property(String id, String name, String type, byte[] value, Checkpoint checkpoint) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.value = value;
        this.checkpoint = checkpoint;
    }

    public Property() {
        this.id = Property.$default$id();
    }

    public static class PropertyBuilder {
        private boolean id$set;
        private String id$value;
        private String name;
        private String type;
        private byte[] value;
        private Checkpoint checkpoint;

        PropertyBuilder() {
        }

        public PropertyBuilder id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        public PropertyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PropertyBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PropertyBuilder value(byte[] value) {
            this.value = value;
            return this;
        }

        public PropertyBuilder checkpoint(Checkpoint checkpoint) {
            this.checkpoint = checkpoint;
            return this;
        }

        public Property build() {
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = Property.$default$id();
            }
            return new Property(id$value, this.name, this.type, this.value, this.checkpoint);
        }

        public String toString() {
            return "Property.PropertyBuilder(id$value=" + this.id$value + ", name=" + this.name + ", type=" + this.type + ", value=" + Arrays.toString(this.value) + ", checkpoint=" + String.valueOf(this.checkpoint) + ")";
        }
    }
}

