/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.rest.v1.mapper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.qubership.integration.platform.engine.persistence.shared.entity.Checkpoint;
import org.qubership.integration.platform.engine.rest.v1.dto.checkpoint.CheckpointDTO;
import org.qubership.integration.platform.engine.rest.v1.mapper.CheckpointMapper;
import org.springframework.stereotype.Component;

@Component
public class CheckpointMapperImpl
implements CheckpointMapper {
    private final DatatypeFactory datatypeFactory;

    public CheckpointMapperImpl() {
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public CheckpointDTO asDTO(Checkpoint checkpoint) {
        if (checkpoint == null) {
            return null;
        }
        CheckpointDTO.CheckpointDTOBuilder checkpointDTO = CheckpointDTO.builder();
        checkpointDTO.id(checkpoint.getId());
        checkpointDTO.checkpointElementId(checkpoint.getCheckpointElementId());
        checkpointDTO.timestamp(this.xmlGregorianCalendarToString(this.dateToXmlGregorianCalendar(checkpoint.getTimestamp()), null));
        return checkpointDTO.build();
    }

    @Override
    public List<CheckpointDTO> asDTO(List<Checkpoint> checkpoints) {
        if (checkpoints == null) {
            return null;
        }
        ArrayList<CheckpointDTO> list = new ArrayList<CheckpointDTO>(checkpoints.size());
        for (Checkpoint checkpoint : checkpoints) {
            list.add(this.asDTO(checkpoint));
        }
        return list;
    }

    private String xmlGregorianCalendarToString(XMLGregorianCalendar xcal, String dateFormat) {
        if (xcal == null) {
            return null;
        }
        if (dateFormat == null) {
            return xcal.toString();
        }
        Date d = xcal.toGregorianCalendar().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(d);
    }

    private XMLGregorianCalendar dateToXmlGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return this.datatypeFactory.newXMLGregorianCalendar(c);
    }
}

