/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import groovy.lang.GroovyShell;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Route;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.impl.engine.DefaultManagementStrategy;
import org.apache.camel.impl.engine.DefaultStreamCachingStrategy;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.observation.MicrometerObservationTracer;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.tracing.Tracer;
import org.apache.camel.xml.jaxb.JaxbHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.engine.camel.CustomResilienceReifier;
import org.qubership.integration.platform.engine.camel.QipCustomClassResolver;
import org.qubership.integration.platform.engine.camel.converters.FormDataConverter;
import org.qubership.integration.platform.engine.camel.converters.SecurityAccessPolicyConverter;
import org.qubership.integration.platform.engine.camel.history.FilteringMessageHistoryFactory;
import org.qubership.integration.platform.engine.configuration.ApplicationConfiguration;
import org.qubership.integration.platform.engine.configuration.PredeployCheckKafkaConfiguration;
import org.qubership.integration.platform.engine.configuration.ServerConfiguration;
import org.qubership.integration.platform.engine.configuration.TracingConfiguration;
import org.qubership.integration.platform.engine.consul.DeploymentReadinessService;
import org.qubership.integration.platform.engine.consul.EngineStateReporter;
import org.qubership.integration.platform.engine.controlplane.ControlPlaneException;
import org.qubership.integration.platform.engine.controlplane.ControlPlaneService;
import org.qubership.integration.platform.engine.errorhandling.DeploymentRetriableException;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.events.ConsulSessionCreatedEvent;
import org.qubership.integration.platform.engine.forms.FormData;
import org.qubership.integration.platform.engine.jms.weblogic.WeblogicSecureThreadFactory;
import org.qubership.integration.platform.engine.jms.weblogic.WeblogicSecurityBean;
import org.qubership.integration.platform.engine.jms.weblogic.WeblogicSecurityInterceptStrategy;
import org.qubership.integration.platform.engine.model.ChainElementType;
import org.qubership.integration.platform.engine.model.RuntimeIntegrationCache;
import org.qubership.integration.platform.engine.model.constants.ConnectionSourceType;
import org.qubership.integration.platform.engine.model.constants.EnvironmentSourceType;
import org.qubership.integration.platform.engine.model.deployment.DeploymentOperation;
import org.qubership.integration.platform.engine.model.deployment.engine.DeploymentStatus;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineDeployment;
import org.qubership.integration.platform.engine.model.deployment.engine.EngineState;
import org.qubership.integration.platform.engine.model.deployment.properties.CamelDebuggerProperties;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentConfiguration;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentInfo;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentRouteUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.DeploymentsUpdate;
import org.qubership.integration.platform.engine.model.deployment.update.ElementProperties;
import org.qubership.integration.platform.engine.model.deployment.update.RouteType;
import org.qubership.integration.platform.engine.security.QipSecurityAccessPolicy;
import org.qubership.integration.platform.engine.service.CamelComponentDependencyBinder;
import org.qubership.integration.platform.engine.service.CustomStepReifier;
import org.qubership.integration.platform.engine.service.MaasService;
import org.qubership.integration.platform.engine.service.QuartzSchedulerService;
import org.qubership.integration.platform.engine.service.SdsService;
import org.qubership.integration.platform.engine.service.VariablesService;
import org.qubership.integration.platform.engine.service.debugger.CamelDebugger;
import org.qubership.integration.platform.engine.service.debugger.CamelDebuggerPropertiesService;
import org.qubership.integration.platform.engine.service.debugger.metrics.MetricsStore;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryGroovyShellFactory;
import org.qubership.integration.platform.engine.service.externallibrary.ExternalLibraryService;
import org.qubership.integration.platform.engine.service.externallibrary.GroovyLanguageWithResettableCache;
import org.qubership.integration.platform.engine.service.xmlpreprocessor.XmlConfigurationPreProcessor;
import org.qubership.integration.platform.engine.util.MDCUtil;
import org.qubership.integration.platform.engine.util.SimpleHttpUriUtils;
import org.qubership.integration.platform.engine.util.log.ExtendedErrorLogger;
import org.qubership.integration.platform.engine.util.log.ExtendedErrorLoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.jms.support.destination.JndiDestinationResolver;
import org.springframework.jndi.JndiObjectFactoryBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class IntegrationRuntimeService
implements ApplicationContextAware {
    private static final ExtendedErrorLogger log = ExtendedErrorLoggerFactory.getLogger(IntegrationRuntimeService.class);
    private final ServerConfiguration serverConfiguration;
    private final QuartzSchedulerService quartzSchedulerService;
    private final TracingConfiguration tracingConfiguration;
    private final PredeployCheckKafkaConfiguration predeployCheckKafkaConfiguration;
    private final ExternalLibraryGroovyShellFactory groovyShellFactory;
    private final GroovyLanguageWithResettableCache groovyLanguage;
    private final CamelComponentDependencyBinder dependencyBinder;
    private final MetricsStore metricsStore;
    private final Optional<ExternalLibraryService> externalLibraryService;
    private final Optional<MaasService> maasService;
    private final Optional<ControlPlaneService> controlPlaneService;
    private final Optional<XmlConfigurationPreProcessor> xmlPreProcessor;
    private final VariablesService variablesService;
    private final EngineStateReporter engineStateReporter;
    private final CamelDebuggerPropertiesService propertiesService;
    private final DeploymentReadinessService deploymentReadinessService;
    private final ApplicationConfiguration applicationConfiguration;
    private final Predicate<FilteringMessageHistoryFactory.FilteringEntity> camelMessageHistoryFilter;
    private final RuntimeIntegrationCache deploymentCache = new RuntimeIntegrationCache();
    private final ReadWriteLock processLock = new ReentrantReadWriteLock();
    private final DataSource qrtzDataSource;
    private final Executor deploymentExecutor;
    private final ObjectProvider<WeblogicSecurityBean> wlSecurityBeanProvider;
    private final ObjectProvider<WeblogicSecurityInterceptStrategy> wlSecurityInterceptStrategyProvider;
    private final ObjectProvider<WeblogicSecureThreadFactory> wlSecureThreadFactoryProvider;
    private ApplicationContext applicationContext;
    private final Optional<SdsService> sdsService;
    @Value(value="${qip.camel.stream-caching.enabled}")
    private boolean enableStreamCaching;
    @Value(value="${qip.camel.component.rabbitmq.predeploy-check-enabled}")
    private boolean amqpPredeployCheckEnabled;
    @Value(value="${qip.camel.component.sub-chains.predeploy-check-enabled}")
    private boolean subChainsPredeployCheckEnabled;
    private final int streamCachingBufferSize;

    @Autowired
    public IntegrationRuntimeService(ServerConfiguration serverConfiguration, QuartzSchedulerService quartzSchedulerService, TracingConfiguration tracingConfiguration, PredeployCheckKafkaConfiguration predeployCheckKafkaConfiguration, ExternalLibraryGroovyShellFactory groovyShellFactory, GroovyLanguageWithResettableCache groovyLanguage, MetricsStore metricsStore, CamelComponentDependencyBinder dependencyBinder, Optional<ExternalLibraryService> externalLibraryService, Optional<MaasService> maasService, Optional<ControlPlaneService> controlPlaneService, Optional<XmlConfigurationPreProcessor> xmlPreProcessor, VariablesService variablesService, EngineStateReporter engineStateReporter, @Qualifier(value="deploymentExecutor") Executor deploymentExecutor, CamelDebuggerPropertiesService propertiesService, @Value(value="${qip.camel.stream-caching.buffer.size-kb}") int streamCachingBufferSizeKb, Predicate<FilteringMessageHistoryFactory.FilteringEntity> camelMessageHistoryFilter, @Qualifier(value="qrtzDataSource") DataSource qrtzDataSource, Optional<SdsService> sdsService, DeploymentReadinessService deploymentReadinessService, ApplicationConfiguration applicationConfiguration, ObjectProvider<WeblogicSecurityBean> wlSecurityBeanProvider, ObjectProvider<WeblogicSecurityInterceptStrategy> wlSecurityInterceptStrategyProvider, ObjectProvider<WeblogicSecureThreadFactory> wlSecureThreadFactoryProvider) {
        this.serverConfiguration = serverConfiguration;
        this.quartzSchedulerService = quartzSchedulerService;
        this.tracingConfiguration = tracingConfiguration;
        this.predeployCheckKafkaConfiguration = predeployCheckKafkaConfiguration;
        this.groovyShellFactory = groovyShellFactory;
        this.groovyLanguage = groovyLanguage;
        this.metricsStore = metricsStore;
        this.dependencyBinder = dependencyBinder;
        this.externalLibraryService = externalLibraryService;
        this.maasService = maasService;
        this.controlPlaneService = controlPlaneService;
        this.xmlPreProcessor = xmlPreProcessor;
        this.variablesService = variablesService;
        this.engineStateReporter = engineStateReporter;
        this.deploymentExecutor = deploymentExecutor;
        this.propertiesService = propertiesService;
        this.streamCachingBufferSize = streamCachingBufferSizeKb * 1024;
        this.camelMessageHistoryFilter = camelMessageHistoryFilter;
        this.qrtzDataSource = qrtzDataSource;
        this.sdsService = sdsService;
        this.deploymentReadinessService = deploymentReadinessService;
        this.applicationConfiguration = applicationConfiguration;
        this.wlSecurityBeanProvider = wlSecurityBeanProvider;
        this.wlSecurityInterceptStrategyProvider = wlSecurityInterceptStrategyProvider;
        this.wlSecureThreadFactoryProvider = wlSecureThreadFactoryProvider;
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Async
    @EventListener
    public void onExternalLibrariesUpdated(ConsulSessionCreatedEvent event) {
        this.updateEngineState();
    }

    public List<DeploymentInfo> buildExcludeDeploymentsMap() {
        Lock processLock = this.processLock.writeLock();
        try {
            processLock.lock();
            List<DeploymentInfo> list = this.deploymentCache.getDeployments().values().stream().map(EngineDeployment::getDeploymentInfo).toList();
            return list;
        }
        finally {
            processLock.unlock();
        }
    }

    private Map<String, EngineDeployment> buildActualDeploymentsSnapshot() {
        Lock processLock = this.processLock.writeLock();
        try {
            processLock.lock();
            Map<String, EngineDeployment> map = this.deploymentCache.getDeployments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((EngineDeployment)entry.getValue()).toBuilder().build()));
            return map;
        }
        finally {
            processLock.unlock();
        }
    }

    public void processAndUpdateState(DeploymentsUpdate update, boolean retry) throws ExecutionException, InterruptedException {
        TreeSet chainDeployments;
        ArrayList completableFutures = new ArrayList();
        HashMap<String, TreeSet> updatesPerChain = new HashMap<String, TreeSet>();
        for (DeploymentUpdate deploymentUpdate : update.getUpdate()) {
            chainDeployments = updatesPerChain.computeIfAbsent(deploymentUpdate.getDeploymentInfo().getChainId(), k -> new TreeSet<DeploymentUpdate>(Comparator.comparingLong(d -> d.getDeploymentInfo().getCreatedWhen())));
            chainDeployments.add(deploymentUpdate);
        }
        for (Map.Entry entry : updatesPerChain.entrySet()) {
            chainDeployments = (TreeSet)entry.getValue();
            completableFutures.add(this.process(chainDeployments, DeploymentOperation.UPDATE, retry));
        }
        for (DeploymentUpdate deploymentUpdate : update.getStop()) {
            completableFutures.add(this.process(Collections.singletonList(deploymentUpdate), DeploymentOperation.STOP, retry));
        }
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0])).get();
        this.updateEngineState();
    }

    private synchronized void updateEngineState() {
        this.engineStateReporter.addStateToQueue(EngineState.builder().engine(this.serverConfiguration.getEngineInfo()).deployments(this.buildActualDeploymentsSnapshot()).build());
    }

    private CompletableFuture<?> process(Collection<DeploymentUpdate> chainDeployments, DeploymentOperation operation, boolean retry) {
        return CompletableFuture.runAsync(() -> {
            MDCUtil.setRequestId(UUID.randomUUID().toString());
            for (DeploymentUpdate chainDeployment : chainDeployments) {
                block7: {
                    log.info("Start processing deployment {}, operation: {}", (Object)chainDeployment.getDeploymentInfo(), (Object)operation);
                    Lock chainLock = this.getCache().getLockForChain(chainDeployment.getDeploymentInfo().getChainId());
                    try {
                        chainLock.lock();
                        log.debug("Locked by-chain lock");
                        if (retry && !this.getCache().getDeployments().containsKey(chainDeployment.getDeploymentInfo().getDeploymentId())) break block7;
                        Lock processWeakLock = this.processLock.readLock();
                        try {
                            processWeakLock.lock();
                            log.debug("Locked process read lock");
                            this.processDeploymentUpdate(chainDeployment, operation);
                        }
                        finally {
                            processWeakLock.unlock();
                            log.debug("Unlocked process read lock");
                        }
                    }
                    finally {
                        chainLock.unlock();
                        log.debug("Unlocked by-chain lock");
                    }
                }
                log.info("Deployment {} processing completed", (Object)chainDeployment.getDeploymentInfo().getDeploymentId());
            }
        }, this.deploymentExecutor);
    }

    /*
     * Exception decompiling
     */
    private void processDeploymentUpdate(DeploymentUpdate deployment, DeploymentOperation operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isDeploymentsSuspended() {
        return !this.deploymentReadinessService.isInitialized();
    }

    private String getCPRouteHash(DeploymentRouteUpdate route) {
        if (route.getPath() == null) {
            return null;
        }
        String strToHash = StringUtils.joinWith((String)",", (Object[])new Object[]{route.getPath(), route.getConnectTimeout()});
        return DigestUtils.sha1Hex((String)strToHash);
    }

    private void resolveVariablesInRoutes(DeploymentUpdate deploymentUpdate) {
        deploymentUpdate.getConfiguration().getRoutes().stream().filter(route -> Objects.nonNull(route.getVariableName()) && (RouteType.EXTERNAL_SENDER == route.getType() || RouteType.EXTERNAL_SERVICE == route.getType())).filter(route -> this.variablesService.hasVariableReferences(route.getPath())).forEach(route -> route.setPath(this.variablesService.injectVariables(route.getPath())));
    }

    private void prepareAndRegisterRoutesInControlPlane(DeploymentUpdate deployment) {
        if (this.controlPlaneService.isPresent()) {
            this.resolveVariablesInRoutes(deployment);
            List<DeploymentRouteUpdate> gatewayTriggersRoutes = deployment.getConfiguration().getRoutes().stream().filter(route -> RouteType.triggerRouteWithGateway(route.getType())).peek(externalRoute -> externalRoute.setPath("/" + StringUtils.strip((String)externalRoute.getPath(), (String)"/"))).toList();
            try {
                this.controlPlaneService.get().postPublicEngineRoutes(gatewayTriggersRoutes.stream().filter(route -> RouteType.isPublicTriggerRoute(route.getType())).toList(), this.applicationConfiguration.getDeploymentName());
                this.controlPlaneService.get().postPrivateEngineRoutes(gatewayTriggersRoutes.stream().filter(route -> RouteType.isPrivateTriggerRoute(route.getType())).toList(), this.applicationConfiguration.getDeploymentName());
                this.controlPlaneService.get().removeEngineRoutesByPathsAndEndpoint(deployment.getConfiguration().getRoutes().stream().filter(route -> RouteType.triggerRouteCleanupNeeded(route.getType())).map(route -> Pair.of((Object)route.getPath(), (Object)((Object)route.getType()))).toList(), this.applicationConfiguration.getDeploymentName());
                deployment.getConfiguration().getRoutes().stream().filter(route -> route.getType() == RouteType.EXTERNAL_SENDER || route.getType() == RouteType.EXTERNAL_SERVICE).forEach(route -> this.controlPlaneService.get().postEgressGatewayRoutes(this.formatServiceRoutes((DeploymentRouteUpdate)route)));
            }
            catch (ControlPlaneException e) {
                throw new DeploymentRetriableException(e);
            }
        }
    }

    @NotNull
    private DeploymentRouteUpdate formatServiceRoutes(DeploymentRouteUpdate route) {
        DeploymentRouteUpdate routeUpdate = route;
        if (Objects.nonNull(routeUpdate.getVariableName()) && RouteType.EXTERNAL_SERVICE == routeUpdate.getType()) {
            routeUpdate = routeUpdate.toBuilder().build();
            try {
                routeUpdate.setPath(SimpleHttpUriUtils.formatUri(routeUpdate.getPath()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            String pathHash = this.getCPRouteHash(routeUpdate);
            if (!StringUtils.isBlank((CharSequence)pathHash)) {
                routeUpdate.setGatewayPrefix(routeUpdate.getGatewayPrefix() + "/" + pathHash);
            }
        }
        return routeUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkKafkaTopicsAndConnection(DeploymentUpdate deployment) throws UnknownTopicOrPartitionException {
        for (ElementProperties elementProperties : deployment.getConfiguration().getProperties()) {
            ChainElementType chainElementType = ChainElementType.fromString(elementProperties.getProperties().get("elementType"));
            String elementId = elementProperties.getProperties().get("elementId");
            try {
                HashSet<String> topics;
                MDC.put((String)"elementId", (String)elementId);
                Map<String, String> props = elementProperties.getProperties();
                if (!ChainElementType.isKafkaAsyncElement(chainElementType)) continue;
                String brokers = this.variablesService.injectVariables(props.get("brokers"));
                String securityProtocol = this.variablesService.injectVariables(props.get("securityProtocol"));
                String saslMechanism = this.variablesService.injectVariables(props.get("saslMechanism"));
                String saslJaasConfig = this.variablesService.injectVariables(props.get("saslJaasConfig"));
                String topicsString = this.variablesService.injectVariables(props.get("topics"));
                if (brokers == null) {
                    log.debug("Element with id {} not contains kafka connection params, skipping", (Object)elementProperties.getElementId());
                    continue;
                }
                Map<String, Object> validationKafkaAdminConfig = this.predeployCheckKafkaConfiguration.createValidationKafkaAdminConfig(brokers, securityProtocol, saslMechanism, saslJaasConfig);
                try (AdminClient client = AdminClient.create(validationKafkaAdminConfig);){
                    Set kafkaTopics = (Set)client.listTopics().names().get();
                    String[] topicsArray = topicsString.split(",");
                    topics = new HashSet<String>();
                    if (topicsArray.length == 0) {
                        throw new KafkaException("Topic property can't be empty");
                    }
                    topics.add(topicsArray[0]);
                    topics.removeAll(kafkaTopics);
                }
                if (topics.isEmpty()) continue;
                String topicString = String.join((CharSequence)", ", topics);
                throw new DeploymentRetriableException("Kafka topics (" + topicString + ") not found, check if this topics exists in kafka");
            }
            catch (ExecutionException | KafkaException e) {
                if (e instanceof AuthorizationException || e.getCause() instanceof AuthorizationException) {
                    log.warn("Kafka predeploy check is failed with AuthorizationException. Exception not thrown", e);
                    continue;
                }
                log.warn("Kafka predeploy check is failed. Connection configuration is invalid, topics not found or broker is unavailable", e);
                throw new DeploymentRetriableException("Kafka predeploy check is failed. Connection configuration is invalid, topics not found or broker is unavailable", (Exception)e);
            }
            catch (DeploymentRetriableException e) {
                log.warn("Kafka predeploy check is failed with retriable exception", e);
                throw e;
            }
            catch (Exception e) {
                log.warn("Failed to check kafka topic(s) or connection for deployment: {}, element: {}", deployment.getDeploymentInfo().getDeploymentId(), elementProperties.getElementId(), e);
            }
            finally {
                MDC.remove((String)"elementId");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAmqpConnection(DeploymentUpdate deployment) {
        for (ElementProperties elementProperties : deployment.getConfiguration().getProperties()) {
            ChainElementType chainElementType = ChainElementType.fromString(elementProperties.getProperties().get("elementType"));
            String elementId = elementProperties.getProperties().get("elementId");
            try {
                MDC.put((String)"elementId", (String)elementId);
                Map<String, String> props = elementProperties.getProperties();
                if (!ChainElementType.isAmqpAsyncElement(chainElementType) || !ConnectionSourceType.MAAS.toString().equalsIgnoreCase(props.get("connectionSourceType")) && !EnvironmentSourceType.MAAS_BY_CLASSIFIER.toString().equalsIgnoreCase(props.get("connectionSourceType")) || StringUtils.containsAnyIgnoreCase((CharSequence)chainElementType.name(), (CharSequence[])new CharSequence[]{ChainElementType.ASYNCAPI_TRIGGER.name(), ChainElementType.SERVICE_CALL.name()}) && !"amqp".equals(this.variablesService.injectVariables(props.get("integrationOperationProtocolType")))) continue;
                boolean isProducerElement = ChainElementType.isAmqpProducerElement(chainElementType);
                String exchange = this.variablesService.injectVariables(props.get("exchange"));
                String queues = this.variablesService.injectVariables(props.get("queues"));
                String addresses = this.variablesService.injectVariables(props.get("addresses"));
                String username = this.variablesService.injectVariables(props.get("username"));
                String password = this.variablesService.injectVariables(props.get("password"));
                String vhost = this.variablesService.injectVariables(props.get("vhost"));
                String ssl = this.variablesService.injectVariables(props.get("sslProtocol"));
                if (StringUtils.isBlank((CharSequence)exchange) || StringUtils.isBlank((CharSequence)addresses)) {
                    throw new IllegalArgumentException("AMQP mandatory parameters are missing, check configuration");
                }
                if (!addresses.matches("^[\\w.,:\\-_]+$")) {
                    throw new IllegalArgumentException("AMQP addresses has invalid format, check configuration");
                }
                ConnectionFactory factory = new ConnectionFactory();
                factory.setUri((StringUtils.isNotBlank((CharSequence)ssl) && ssl.equals("true") ? "amqps://" : "amqp://") + addresses);
                if (StringUtils.isNotBlank((CharSequence)username)) {
                    factory.setUsername(username);
                }
                if (StringUtils.isNotBlank((CharSequence)password)) {
                    factory.setPassword(password);
                }
                if (StringUtils.isNotBlank((CharSequence)vhost)) {
                    factory.setVirtualHost(vhost);
                }
                try {
                    com.rabbitmq.client.Connection connection = factory.newConnection();
                    try {
                        Channel channel = connection.createChannel();
                        try {
                            if (isProducerElement) {
                                channel.exchangeDeclarePassive(exchange);
                                continue;
                            }
                            channel.queueDeclarePassive(queues);
                        }
                        catch (IOException e) {
                            throw new DeploymentRetriableException("AMQP " + (isProducerElement ? "exchange " + exchange : "queue(s) " + queues) + " not found, check configuration");
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (IOException e) {
                    throw new DeploymentRetriableException("Connection configuration is invalid or broker is unavailable", e);
                }
            }
            catch (IllegalArgumentException e) {
                log.error("AMQP predeploy check is failed", e);
                throw e;
            }
            catch (DeploymentRetriableException e) {
                log.warn("AMQP predeploy check is failed with retriable exception", e);
                throw e;
            }
            catch (Exception e) {
                log.warn("Failed to check amqp connection for deployment: {}, element: {}", deployment.getDeploymentInfo().getDeploymentId(), elementProperties.getElementId(), e);
            }
            finally {
                MDC.remove((String)"elementId");
            }
        }
    }

    private DeploymentStatus processDeployment(DeploymentUpdate deployment, DeploymentOperation operation) throws Exception {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case DeploymentOperation.UPDATE -> this.update(deployment);
            case DeploymentOperation.STOP -> this.stop(deploymentInfo.getDeploymentId());
        };
    }

    private DeploymentStatus update(DeploymentUpdate deployment) throws Exception {
        DeploymentInfo deploymentInfo = deployment.getDeploymentInfo();
        String deploymentId = deploymentInfo.getDeploymentId();
        DeploymentConfiguration configuration = deployment.getConfiguration();
        String configurationXml = configuration.getXml();
        configurationXml = this.variablesService.injectVariables(configurationXml, true);
        if (this.maasService.isPresent()) {
            configurationXml = this.maasService.get().resolveDeploymentMaasParameters(configuration, configurationXml);
        }
        configurationXml = this.resolveRouteVariables(deployment.getConfiguration().getRoutes(), configurationXml);
        if (this.xmlPreProcessor.isPresent()) {
            configurationXml = this.xmlPreProcessor.get().process(configurationXml);
        }
        if (this.predeployCheckKafkaConfiguration.isCamelKafkaPredeployCheckEnabled()) {
            this.checkKafkaTopicsAndConnection(deployment);
        }
        if (this.amqpPredeployCheckEnabled) {
            this.checkAmqpConnection(deployment);
        }
        if (deployment.getDeploymentInfo().isContainsSchedulerElements()) {
            this.checkSchedulerRequirements();
        }
        if (CollectionUtils.isNotEmpty(deployment.getDeploymentInfo().getDependencyChainIds()) && this.subChainsPredeployCheckEnabled) {
            this.checkDependencyDeployments(deployment);
        }
        this.checkSdsConnection(deployment);
        this.propertiesService.mergeWithRuntimeProperties(CamelDebuggerProperties.builder().deploymentInfo(deployment.getDeploymentInfo()).maskedFields(deployment.getMaskedFields()).properties(configuration.getProperties()).build());
        SpringCamelContext context = (SpringCamelContext)this.getCache().getContexts().get(deploymentId);
        if (context != null && log.isDebugEnabled()) {
            log.debug("Context for deployment {} already exists", (Object)deploymentId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating context for deployment {}", (Object)deploymentId);
        }
        context = this.createContext(deploymentInfo, configuration, configurationXml);
        CamelDebugger debugger = (CamelDebugger)((Object)this.applicationContext.getBean(CamelDebugger.class));
        debugger.setDeploymentId(deploymentId);
        LinkedList<SpringCamelContext> contextsToRemove = new LinkedList<SpringCamelContext>(this.getContextsRelatedToDeployment(deployment, state -> !state.getDeploymentInfo().getDeploymentId().equals(deployment.getDeploymentInfo().getDeploymentId())));
        try {
            this.startContext(context, debugger, deploymentId);
        }
        catch (Exception e) {
            this.quartzSchedulerService.commitScheduledJobs();
            this.sdsService.ifPresent(bean -> bean.removeSchedulerJobs(deploymentId));
            throw e;
        }
        this.quartzSchedulerService.removeSchedulerJobsFromContexts(contextsToRemove);
        this.sdsService.ifPresent(bean -> bean.removeSchedulerJobs(contextsToRemove));
        contextsToRemove.stream().filter(SpringCamelContext::isRunning).forEach(SpringCamelContext::stop);
        this.quartzSchedulerService.commitScheduledJobs();
        if (log.isDebugEnabled()) {
            log.debug("Context for deployment {} has started", (Object)deploymentId);
        }
        return DeploymentStatus.DEPLOYED;
    }

    private void checkSchedulerRequirements() {
        if (!this.isSchedulerDatabaseReady()) {
            log.warn("Failed to obtain DB connection for scheduler");
            throw new DeploymentRetriableException("Failed to obtain DB connection for scheduler");
        }
        log.debug("Scheduler database is ready");
    }

    private void checkDependencyDeployments(DeploymentUpdate deployment) {
        if (deployment.getDeploymentInfo().getDependencyChainIds() == null) {
            return;
        }
        List<String> undeployedDependencyChainIds = deployment.getDeploymentInfo().getDependencyChainIds().stream().filter(chainId -> this.getCache().getDeployments().values().stream().noneMatch(engineDeployment -> engineDeployment.getDeploymentInfo().getChainId().equals(chainId) && engineDeployment.getStatus().equals((Object)DeploymentStatus.DEPLOYED))).toList();
        if (!undeployedDependencyChainIds.isEmpty()) {
            String undeployedDependencyChainsNames = String.join((CharSequence)", ", undeployedDependencyChainIds);
            throw new DeploymentRetriableException("Related sub-chains are not deployed yet: ".concat(undeployedDependencyChainsNames));
        }
    }

    private void checkSdsConnection(DeploymentUpdate deployment) {
        for (ElementProperties elementProperties : deployment.getConfiguration().getProperties()) {
            ChainElementType chainElementType = ChainElementType.fromString(elementProperties.getProperties().get("elementType"));
            if (!ChainElementType.isSdsTriggerElement(chainElementType)) continue;
            try {
                this.sdsService.ifPresent(SdsService::getJobsMetadata);
            }
            catch (Exception exception) {
                log.warn("Sds trigger predeploy check failed. Please check scheduling-service");
                throw new DeploymentRetriableException("Sds trigger predeploy check failed. Please check scheduling-service", exception);
            }
        }
    }

    private boolean isSchedulerDatabaseReady() {
        boolean bl;
        block8: {
            Connection conn = this.qrtzDataSource.getConnection();
            try {
                boolean bl2 = bl = conn != null;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Scheduler database not ready", e);
                    return false;
                }
            }
            conn.close();
        }
        return bl;
    }

    private String resolveRouteVariables(List<DeploymentRouteUpdate> routes, String text) {
        String result = text;
        for (DeploymentRouteUpdate route : routes) {
            DeploymentRouteUpdate tempRoute = this.formatServiceRoutes(route);
            RouteType type = tempRoute.getType();
            if (!Objects.nonNull(tempRoute.getVariableName()) || RouteType.EXTERNAL_SENDER != type && RouteType.EXTERNAL_SERVICE != type) continue;
            String variablePlaceholder = String.format("%%%%{%s}", tempRoute.getVariableName());
            String gatewayPrefix = tempRoute.getGatewayPrefix();
            result = result.replace(variablePlaceholder, Objects.isNull(gatewayPrefix) ? "" : gatewayPrefix);
        }
        return result;
    }

    private void removeOldDeployments(DeploymentUpdate deployment, Function<DeploymentStatus, Boolean> statusCondition) {
        Iterator iterator = this.getCache().getDeployments().entrySet().iterator();
        ArrayList<SpringCamelContext> contextsToRemove = new ArrayList<SpringCamelContext>();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DeploymentInfo depInfo = ((EngineDeployment)entry.getValue()).getDeploymentInfo();
            if (!depInfo.getChainId().equals(deployment.getDeploymentInfo().getChainId()) || !statusCondition.apply(((EngineDeployment)entry.getValue()).getStatus()).booleanValue() || depInfo.getDeploymentId().equals(deployment.getDeploymentInfo().getDeploymentId())) continue;
            SpringCamelContext toRemoveContext = (SpringCamelContext)this.getCache().getContexts().remove(entry.getKey());
            if (toRemoveContext != null) {
                contextsToRemove.add(toRemoveContext);
            }
            this.removeRetryingDeployment(depInfo.getDeploymentId());
            this.metricsStore.removeChainsDeployments(depInfo.getDeploymentId());
            iterator.remove();
            this.propertiesService.removeDeployProperties((String)entry.getKey());
        }
        contextsToRemove.stream().filter(SpringCamelContext::isRunning).forEach(SpringCamelContext::stop);
    }

    private List<SpringCamelContext> getContextsRelatedToDeployment(DeploymentUpdate deployment) {
        return this.getContextsRelatedToDeployment(deployment, state -> true);
    }

    private List<SpringCamelContext> getContextsRelatedToDeployment(DeploymentUpdate deployment, Function<EngineDeployment, Boolean> filter) {
        return this.getCache().getDeployments().entrySet().stream().filter(entry -> ((EngineDeployment)entry.getValue()).getDeploymentInfo().getChainId().equals(deployment.getDeploymentInfo().getChainId()) && (Boolean)filter.apply((EngineDeployment)entry.getValue()) != false).map(Map.Entry::getKey).map(this.getCache().getContexts()::get).filter(Objects::nonNull).toList();
    }

    private SpringCamelContext createContext(DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration, String configurationXml) throws Exception {
        SpringCamelContext context = new SpringCamelContext(this.applicationContext);
        context.getTypeConverterRegistry().addTypeConverter(FormData.class, String.class, (TypeConverter)this.applicationContext.getBean(FormDataConverter.class));
        context.getTypeConverterRegistry().addTypeConverter(QipSecurityAccessPolicy.class, String.class, (TypeConverter)this.applicationContext.getBean(SecurityAccessPolicyConverter.class));
        context.getGlobalOptions().put("CamelJacksonEnableTypeConverter", "true");
        context.getGlobalOptions().put("CamelJacksonTypeConverterToPojo", "true");
        this.dependencyBinder.bindToRegistry(context, deploymentInfo, deploymentConfiguration);
        boolean deploymentsSuspended = this.isDeploymentsSuspended();
        if (deploymentsSuspended) {
            context.setAutoStartup(Boolean.valueOf(false));
            log.debug("Deployment {} will be suspended due to pod initialization", (Object)deploymentInfo.getDeploymentId());
        }
        context.setClassResolver(this.getClassResolver(context, deploymentConfiguration));
        this.loadRoutes(context, configurationXml);
        this.getCache().getContexts().put(deploymentInfo.getDeploymentId(), context);
        this.registerComponents(context, deploymentInfo, deploymentConfiguration);
        return context;
    }

    private ClassResolver getClassResolver(SpringCamelContext context, DeploymentConfiguration deploymentConfiguration) {
        List<String> systemModelIds = deploymentConfiguration.getProperties().stream().map(ElementProperties::getProperties).filter(properties -> "service-call".equals(properties.get("elementType"))).map(properties -> (String)properties.get("integrationSpecificationId")).filter(Objects::nonNull).toList();
        ClassLoader classLoader = this.externalLibraryService.isPresent() ? this.externalLibraryService.get().getClassLoaderForSystemModels(systemModelIds, context.getApplicationContextClassLoader()) : this.getClass().getClassLoader();
        return new QipCustomClassResolver(classLoader);
    }

    private void registerComponents(SpringCamelContext context, DeploymentInfo deploymentInfo, DeploymentConfiguration deploymentConfiguration) throws NamingException {
        ArrayList<Map<String, String>> sdsElementsProperties = new ArrayList<Map<String, String>>();
        for (ElementProperties elementProperties : deploymentConfiguration.getProperties()) {
            String elementId = elementProperties.getElementId();
            Map<String, String> properties = elementProperties.getProperties();
            ChainElementType elementType = ChainElementType.fromString(properties.get("elementType"));
            switch (elementType) {
                case JMS_SENDER: 
                case JMS_TRIGGER: {
                    this.registerJmsComponent(context, elementId, properties);
                    break;
                }
                case SDS_TRIGGER: {
                    sdsElementsProperties.add(properties);
                }
            }
        }
        this.sdsService.ifPresent(bean -> bean.registerSchedulerJobs(context, deploymentInfo, sdsElementsProperties));
    }

    private void registerJmsComponent(SpringCamelContext context, String elementId, Map<String, String> properties) throws NamingException {
        boolean secured;
        Properties environment = new Properties();
        String jmsInitialContextFactory = this.variablesService.injectVariables(properties.get("initialContextFactory"));
        String jmsProviderUrl = this.variablesService.injectVariables(properties.get("providerUrl"));
        String jmsConnectionFactoryName = this.variablesService.injectVariables(properties.get("connectionFactoryName"));
        String username = this.variablesService.injectVariables(properties.get("username"));
        String password = this.variablesService.injectVariables(properties.get("password"));
        environment.put("java.naming.factory.initial", jmsInitialContextFactory);
        environment.put("java.naming.provider.url", jmsProviderUrl);
        boolean bl = secured = !StringUtils.isBlank((CharSequence)username) && !StringUtils.isBlank((CharSequence)password);
        if (secured) {
            environment.put("java.naming.security.principal", username);
            environment.put("java.naming.security.credentials", password);
        }
        JndiTemplate jmsJndiTemplate = new JndiTemplate(environment);
        JndiObjectFactoryBean jmsConnectionFactory = new JndiObjectFactoryBean();
        jmsConnectionFactory.setJndiTemplate(jmsJndiTemplate);
        jmsConnectionFactory.setJndiName(jmsConnectionFactoryName);
        jmsConnectionFactory.setProxyInterface(jakarta.jms.ConnectionFactory.class);
        jmsConnectionFactory.setLookupOnStartup(false);
        jmsConnectionFactory.setExposeAccessContext(true);
        jmsConnectionFactory.afterPropertiesSet();
        JndiDestinationResolver jndiDestinationResolver = new JndiDestinationResolver();
        jndiDestinationResolver.setJndiTemplate(jmsJndiTemplate);
        jndiDestinationResolver.setFallbackToDynamicDestination(true);
        JmsConfiguration jmsConfiguration = new JmsConfiguration();
        jmsConfiguration.setConnectionFactory((jakarta.jms.ConnectionFactory)jmsConnectionFactory.getObject());
        jmsConfiguration.setDestinationResolver((DestinationResolver)jndiDestinationResolver);
        WeblogicSecurityBean wlSecurityBean = (WeblogicSecurityBean)this.wlSecurityBeanProvider.getIfAvailable();
        WeblogicSecureThreadFactory wlSecureThreadFactory = (WeblogicSecureThreadFactory)this.wlSecureThreadFactoryProvider.getIfAvailable();
        WeblogicSecurityInterceptStrategy wlSecurityInterceptStrategy = (WeblogicSecurityInterceptStrategy)this.wlSecurityInterceptStrategyProvider.getIfAvailable();
        if (secured && wlSecurityBean != null && wlSecureThreadFactory != null && wlSecurityInterceptStrategy != null) {
            wlSecurityBean.setProviderUrl(jmsProviderUrl);
            wlSecurityBean.setSecurityPrincipal(username);
            wlSecurityBean.setSecurityCredentials(password);
            wlSecureThreadFactory.setName("jms-thread-factory-" + elementId);
            wlSecureThreadFactory.setWeblogicSecurityBean(wlSecurityBean);
            ThreadPoolProfile profile = context.getExecutorServiceManager().getDefaultThreadPoolProfile();
            ThreadPoolTaskExecutor jmsTaskExecutor = new ThreadPoolTaskExecutor();
            jmsTaskExecutor.setBeanName("jms-task-executor-" + elementId);
            jmsTaskExecutor.setThreadFactory((ThreadFactory)wlSecureThreadFactory);
            jmsTaskExecutor.setCorePoolSize(profile.getPoolSize().intValue());
            jmsTaskExecutor.setMaxPoolSize(profile.getMaxPoolSize().intValue());
            jmsTaskExecutor.setKeepAliveSeconds(profile.getKeepAliveTime().intValue());
            jmsTaskExecutor.setQueueCapacity(profile.getMaxQueueSize().intValue());
            jmsTaskExecutor.afterPropertiesSet();
            jmsConfiguration.setTaskExecutor((TaskExecutor)jmsTaskExecutor);
            wlSecurityInterceptStrategy.setTargetId(elementId);
            wlSecurityInterceptStrategy.setWeblogicSecurityBean(wlSecurityBean);
            context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)wlSecurityInterceptStrategy);
        }
        JmsComponent jmsComponent = new JmsComponent(jmsConfiguration);
        String componentName = this.buildJmsComponentName(elementId, properties);
        context.addComponent(componentName, (Component)jmsComponent);
    }

    private String buildJmsComponentName(String elementId, Map<String, String> properties) {
        return String.format("jms-%s", elementId);
    }

    private void startContext(SpringCamelContext context, CamelDebugger debugger, String contextMgmtSuffix) {
        context.setApplicationContext(this.applicationContext);
        context.setManagementName("camel-context_" + contextMgmtSuffix);
        context.setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy((CamelContext)context));
        context.setDebugger((Debugger)debugger);
        context.setDebugging(Boolean.valueOf(true));
        this.configureMessageHistoryFactory(context);
        context.setStreamCaching(Boolean.valueOf(this.enableStreamCaching));
        if (this.enableStreamCaching) {
            DefaultStreamCachingStrategy streamCachingStrategy = new DefaultStreamCachingStrategy();
            streamCachingStrategy.setBufferSize(this.streamCachingBufferSize);
            context.setStreamCachingStrategy((StreamCachingStrategy)streamCachingStrategy);
        }
        if (this.tracingConfiguration.isTracingEnabled()) {
            Tracer tracer = (Tracer)this.applicationContext.getBean("camelObservationTracer", MicrometerObservationTracer.class);
            tracer.init((CamelContext)context);
        }
        context.start();
        if (!debugger.isStartingOrStarted()) {
            debugger.start();
        }
    }

    private void configureMessageHistoryFactory(SpringCamelContext context) {
        context.setMessageHistory(Boolean.valueOf(true));
        MessageHistoryFactory defaultFactory = context.getMessageHistoryFactory();
        FilteringMessageHistoryFactory factory = new FilteringMessageHistoryFactory(this.camelMessageHistoryFilter, defaultFactory);
        context.setMessageHistoryFactory((MessageHistoryFactory)factory);
    }

    private void loadRoutes(SpringCamelContext context, String xmlConfiguration) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Loading routes from: \n{}", (Object)xmlConfiguration);
        }
        byte[] configurationBytes = xmlConfiguration.getBytes();
        ByteArrayInputStream configInputStream = new ByteArrayInputStream(configurationBytes);
        RoutesDefinition routesDefinition = JaxbHelper.loadRoutesDefinition((CamelContext)context, (InputStream)configInputStream);
        for (RouteDefinition route : routesDefinition.getRoutes()) {
            RouteDefinitionHelper.prepareRoute((CamelContext)context, (RouteDefinition)route);
            route.markPrepared();
        }
        routesDefinition.getRoutes().forEach(RouteDefinition::markUnprepared);
        this.compileGroovyScripts(routesDefinition);
        context.addRouteDefinitions((Collection)routesDefinition.getRoutes());
    }

    private void compileGroovyScripts(RoutesDefinition routesDefinition) {
        for (RouteDefinition route : routesDefinition.getRoutes()) {
            for (ProcessorDefinition processor : route.getOutputs()) {
                ExpressionDefinition expression;
                if (!(processor instanceof ExpressionNode) || !(expression = ((ExpressionNode)processor).getExpression()).getLanguage().equals("groovy")) continue;
                log.debug("Compiling groovy script for processor {}", (Object)processor.getId());
                this.compileGroovyScript(expression);
            }
        }
    }

    private void compileGroovyScript(ExpressionDefinition expression) {
        try {
            String text = expression.getExpression();
            if (Objects.isNull(expression.getTrim()) || Boolean.parseBoolean(expression.getTrim())) {
                text = text.trim();
            }
            GroovyShell groovyShell = this.groovyShellFactory.createGroovyShell(null);
            Class scriptClass = groovyShell.getClassLoader().parseClass(text);
            this.groovyLanguage.addScriptToCache(text, scriptClass);
        }
        catch (CompilationFailedException exception) {
            if (IntegrationRuntimeService.isClassResolveError(exception)) {
                throw new DeploymentRetriableException("Failed to compile groovy script.", (Exception)((Object)exception));
            }
            throw new RuntimeException("Failed to compile groovy script.", exception);
        }
    }

    private static boolean isClassResolveError(CompilationFailedException exception) {
        return exception.getMessage().contains("unable to resolve class");
    }

    private DeploymentStatus stop(String deploymentId) {
        this.stopContext(deploymentId);
        return DeploymentStatus.REMOVED;
    }

    private void stopContext(String deploymentId) {
        SpringCamelContext context = (SpringCamelContext)this.getCache().getContexts().remove(deploymentId);
        this.sdsService.ifPresent(bean -> bean.removeSchedulerJobs(deploymentId));
        if (context != null) {
            log.debug("Removing context for deployment: {}", (Object)deploymentId);
            this.quartzSchedulerService.removeSchedulerJobsFromContexts(Collections.singletonList(context));
            context.stop();
        }
    }

    public void retryProcessingDeploys() {
        try {
            Collection<DeploymentUpdate> toRetry = this.getCache().flushDeploymentsToRetry();
            if (!toRetry.isEmpty()) {
                this.processAndUpdateState(DeploymentsUpdate.builder().update(toRetry).build(), true);
            }
        }
        catch (Exception e) {
            log.error("Failed to process retry deployments", e);
        }
    }

    private void putInRetryQueue(DeploymentUpdate deploymentUpdate) {
        log.info("Deployment marked for retry {}", (Object)deploymentUpdate.getDeploymentInfo().getDeploymentId());
        this.getCache().putToRetryQueue(deploymentUpdate);
    }

    private void removeRetryingDeployment(String deploymentId) {
        this.getCache().removeRetryDeploymentFromQueue(deploymentId);
    }

    private RuntimeIntegrationCache getCache() {
        return this.deploymentCache;
    }

    public void startAllRoutesOnInit() {
        this.getCache().getContexts().forEach((deploymentId, context) -> {
            EngineDeployment state = (EngineDeployment)this.getCache().getDeployments().get(deploymentId);
            try {
                context.startAllRoutes();
                log.debug("Deployment {} was resumed from suspend", deploymentId);
            }
            catch (Exception e) {
                if (state != null) {
                    state.setStatus(DeploymentStatus.FAILED);
                    state.setErrorMessage("Deployment wasn't initialized correctly during pod startup " + e.getMessage());
                }
                ErrorCode errorCode = ErrorCode.DEPLOYMENT_START_ERROR;
                log.error(errorCode, errorCode.compileMessage((String)deploymentId), (Throwable)e);
            }
            finally {
                if (state != null) {
                    state.setSuspended(false);
                }
            }
        });
    }

    private static /* synthetic */ Boolean lambda$processDeploymentUpdate$6(DeploymentStatus deploymentStatus) {
        return deploymentStatus == DeploymentStatus.FAILED || deploymentStatus == DeploymentStatus.PROCESSING;
    }

    private static /* synthetic */ Boolean lambda$processDeploymentUpdate$5(DeploymentStatus deploymentStatus) {
        return true;
    }

    static {
        ProcessorReifier.registerReifier(StepDefinition.class, CustomStepReifier::new);
        ProcessorReifier.registerReifier(CircuitBreakerDefinition.class, (route, definition) -> new CustomResilienceReifier((Route)route, (CircuitBreakerDefinition)definition));
    }
}

