/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.debugger.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.support.http.HttpUtil;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.engine.camel.context.propagation.CamelExchangeContextPropagation;
import org.qubership.integration.platform.engine.errorhandling.LoggingMaskingException;
import org.qubership.integration.platform.engine.errorhandling.errorcode.ErrorCode;
import org.qubership.integration.platform.engine.model.SessionElementProperty;
import org.qubership.integration.platform.engine.service.debugger.masking.MaskingService;
import org.qubership.integration.platform.engine.service.debugger.util.MessageHelper;
import org.qubership.integration.platform.engine.util.ExchangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.UnsupportedMediaTypeException;

@Component
public class PayloadExtractor {
    private static final Logger log = LoggerFactory.getLogger(PayloadExtractor.class);
    private final MaskingService maskingService;
    private final ObjectMapper objectMapper;
    private final Optional<CamelExchangeContextPropagation> exchangeContextPropagation;

    @Autowired
    public PayloadExtractor(MaskingService maskingService, @Qualifier(value="jsonMapper") ObjectMapper objectMapper, Optional<CamelExchangeContextPropagation> exchangeContextPropagation) {
        this.maskingService = maskingService;
        this.objectMapper = objectMapper;
        this.exchangeContextPropagation = exchangeContextPropagation;
    }

    public Map<String, String> extractHeadersForLogging(Exchange exchange, Set<String> maskedFields, boolean maskingEnabled) {
        Map<String, String> headers = exchange.getMessage().getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() != null ? entry.getValue().toString() : ""));
        if (maskingEnabled) {
            this.maskingService.maskFields(headers, maskedFields);
        }
        return headers;
    }

    public String extractBodyForLogging(Exchange exchange, Set<String> maskedFields, boolean maskingEnabled) {
        String maskedBody;
        block3: {
            maskedBody = MessageHelper.extractBody(exchange);
            MimeType contentType = PayloadExtractor.extractContentType(exchange);
            if (maskingEnabled && !maskedFields.isEmpty() && StringUtils.isNotEmpty((CharSequence)maskedBody) && contentType != null) {
                try {
                    maskedBody = this.maskingService.maskFields(maskedBody, maskedFields, contentType);
                }
                catch (LoggingMaskingException | UnsupportedMediaTypeException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Failed to mask fields in body");
                }
            }
        }
        return maskedBody;
    }

    public Map<String, SessionElementProperty> extractExchangePropertiesForLogging(Exchange exchange, Set<String> maskedFields, boolean maskingEnabled) {
        Map<String, SessionElementProperty> properties = ExchangeUtils.prepareExchangePropertiesForLogging(exchange);
        if (maskingEnabled) {
            this.maskingService.maskPropertiesFields(properties, maskedFields);
        }
        for (Map.Entry<String, SessionElementProperty> entry : properties.entrySet()) {
            String key = entry.getKey();
            SessionElementProperty value = entry.getValue();
            try {
                if (maskingEnabled && !maskedFields.isEmpty()) {
                    value.setValue(this.maskingService.maskJSON(value.getValue(), maskedFields));
                }
                properties.put(key, value);
            }
            catch (JsonProcessingException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Property " + key + " has invalid json");
            }
        }
        return properties;
    }

    public Map<String, String> extractContextForLogging(Set<String> maskedFields, boolean maskingEnabled) {
        HashMap<String, String> headers;
        Map<String, String> map = headers = this.exchangeContextPropagation.isPresent() ? this.exchangeContextPropagation.get().buildContextSnapshotForSessions() : new HashMap<String, String>();
        if (maskingEnabled) {
            this.maskingService.maskFields(headers, maskedFields);
        }
        return headers;
    }

    public String convertToJson(Map<String, ?> mapData) {
        if (mapData == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(mapData);
        }
        catch (JsonProcessingException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while logging in json processing {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    public static Integer getResponseCode(Map<String, Object> headers) {
        Object responseCodeObj = headers.get("CamelHttpResponseCode");
        return responseCodeObj == null ? null : Integer.valueOf(responseCodeObj.toString());
    }

    public static int getServletResponseCode(Exchange exchange, Exception exception) {
        if (exception != null) {
            return ErrorCode.match(exception).getHttpErrorCode();
        }
        return HttpUtil.determineResponseCode((Exchange)exchange, (Object)exchange.getMessage().getBody());
    }

    public static MimeType extractContentType(Exchange exchange) {
        Object contentType = exchange.getMessage().getHeaders().getOrDefault("Content-Type", null);
        return contentType == null ? null : MimeType.valueOf((String)String.valueOf(contentType));
    }
}

