/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.engine.service.externallibrary;

import groovy.lang.Script;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.camel.language.groovy.GroovyLanguage;
import org.qubership.integration.platform.engine.events.ExternalLibrariesUpdatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component(value="groovy")
public class GroovyLanguageWithResettableCache
extends GroovyLanguage {
    private static final Logger log = LoggerFactory.getLogger(GroovyLanguageWithResettableCache.class);

    public void resetScriptCache() {
        log.debug("Resetting groovy script cache");
        try {
            this.tryResetScriptCache();
        }
        catch (Exception exception) {
            log.error("Failed to reset groovy script cache", (Throwable)exception);
        }
    }

    public void addScriptToCache(String key, Class<Script> scriptClass) {
        log.debug("Adding compiled groovy script to cache");
        try {
            this.tryAddScriptToCache(key, scriptClass);
        }
        catch (Exception exception) {
            log.error("Failed to add compiled groovy script to cache", (Throwable)exception);
        }
    }

    private void tryResetScriptCache() throws NoSuchFieldException, IllegalAccessException {
        Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("scriptCache");
        field.setAccessible(true);
        Map scriptCache = (Map)field.get((Object)this);
        scriptCache.clear();
    }

    private void tryAddScriptToCache(String key, Class<Script> scriptClass) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredMethod("addScriptToCache", String.class, Class.class);
        method.setAccessible(true);
        method.invoke((Object)this, key, scriptClass);
    }

    @EventListener
    public void onExternalLibrariesUpdated(ExternalLibrariesUpdatedEvent event) {
        if (!event.isInitialUpdate()) {
            this.resetScriptCache();
        }
    }
}

