/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.qubership.integration.platform.catalog.exception.SnapshotCreationException;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ReferenceType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.MappingDescription;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Attribute;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MappingDescriptionValidator {
    private static final Logger log = LoggerFactory.getLogger(MappingDescriptionValidator.class);
    private static final String NO_MAPPING_FOR_REQUIRED_ATTRIBUTES_ERROR_MESSAGE = "No mapping for structure with required attributes.";
    private static final String MANDATORY_FIELDS_MISSING_IN_MAPPING_ERROR_MESSAGE = "Mandatory fields are missing in current mapping.";

    public void validate(MappingDescription mappingDescription) {
        this.validateMandatoryFields(mappingDescription);
    }

    private void validateMandatoryFields(MappingDescription mappingDescription) {
        HashMap pathsToMandatoryAttributes = new HashMap();
        pathsToMandatoryAttributes.putAll(this.getMandatoryHeaders(mappingDescription));
        pathsToMandatoryAttributes.putAll(this.getMandatoryProperties(mappingDescription));
        pathsToMandatoryAttributes.putAll(this.getMandatoryBody(mappingDescription));
        if (!pathsToMandatoryAttributes.isEmpty() && mappingDescription.getActions().isEmpty()) {
            throw new SnapshotCreationException(NO_MAPPING_FOR_REQUIRED_ATTRIBUTES_ERROR_MESSAGE);
        }
        if (!pathsToMandatoryAttributes.isEmpty()) {
            List<List> targetPaths = mappingDescription.getActions().stream().map(mappingAction -> mappingAction.getTarget().getPath()).toList();
            List<Integer> missingMandatoryAttributes = pathsToMandatoryAttributes.keySet().stream().filter(attrId -> {
                List attrPaths = (List)pathsToMandatoryAttributes.get(attrId);
                return targetPaths.stream().noneMatch(targetPath -> Arrays.equals(targetPath.toArray(), attrPaths.toArray()));
            }).toList();
            if (!missingMandatoryAttributes.isEmpty()) {
                throw new SnapshotCreationException(MANDATORY_FIELDS_MISSING_IN_MAPPING_ERROR_MESSAGE);
            }
        }
    }

    private Map<Integer, LinkedList<String>> getMandatoryHeaders(MappingDescription mappingDescription) {
        return mappingDescription.getTarget().getHeaders().stream().filter(Attribute::getRequired).map(Element::getId).collect(Collectors.toMap(String::hashCode, attribute -> new LinkedList()));
    }

    private Map<Integer, LinkedList<String>> getMandatoryProperties(MappingDescription mappingDescription) {
        Collection targetProperties = mappingDescription.getTarget().getProperties();
        HashMap<Integer, LinkedList<String>> pathsToMandatoryProperties = new HashMap<Integer, LinkedList<String>>();
        this.collectMandatoryAttributes(targetProperties, pathsToMandatoryProperties, new LinkedList(), new HashMap());
        return pathsToMandatoryProperties;
    }

    private Map<Integer, LinkedList<String>> getMandatoryBody(MappingDescription mappingDescription) {
        Collection targetAttributes = mappingDescription.getTarget().getBody().getNestedAttributes();
        HashMap<Integer, LinkedList<String>> pathToMandatoryAttributes = new HashMap<Integer, LinkedList<String>>();
        this.collectMandatoryAttributes(targetAttributes, pathToMandatoryAttributes, new LinkedList(), mappingDescription.getTarget().getBodyDefinitions());
        return pathToMandatoryAttributes;
    }

    private void collectMandatoryAttributes(Collection<Attribute> allAttributes, Map<Integer, LinkedList<String>> mandatoryAttributes, LinkedList<String> currentPath, Map<String, DataType> attributeDefinitions) {
        for (Attribute attribute : allAttributes) {
            Collection nestedAttributes;
            DataType resolvedDataType = null;
            boolean mandatoryAttributeFound = attribute.getRequired();
            DataType dataType = attribute.getType();
            if (dataType instanceof ReferenceType) {
                ReferenceType attributeReferenceType = (ReferenceType)dataType;
                resolvedDataType = attributeDefinitions.getOrDefault(attributeReferenceType.getDefinitionId(), null);
            }
            Collection collection = nestedAttributes = resolvedDataType != null ? resolvedDataType.getNestedAttributes() : attribute.getType().getNestedAttributes();
            if (!nestedAttributes.isEmpty()) {
                mandatoryAttributeFound = false;
                currentPath.add(attribute.getId());
                this.collectMandatoryAttributes(nestedAttributes, mandatoryAttributes, currentPath, attributeDefinitions);
            }
            if (!mandatoryAttributeFound) continue;
            currentPath.add(attribute.getId());
            mandatoryAttributes.put(currentPath.hashCode(), new LinkedList<String>(currentPath));
            currentPath.clear();
        }
    }
}

