/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.EscapeUtil;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.FieldKind;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.FieldReference;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.parser.ExpressionParser;
import org.qubership.integration.platform.runtime.catalog.mapper.expressions.parser.ExpressionParserBaseVisitor;

public class ExpressionVisitor
extends ExpressionParserBaseVisitor<String> {
    private final Function<FieldReference, String> fieldIdResolver;

    public ExpressionVisitor(Function<FieldReference, String> fieldIdResolver) {
        this.fieldIdResolver = fieldIdResolver;
    }

    public String visitOrExpression(ExpressionParser.OrExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    public String visitOrOperator(ExpressionParser.OrOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitAndExpression(ExpressionParser.AndExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    public String visitAndOperator(ExpressionParser.AndOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitEqualityExpression(ExpressionParser.EqualityExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    public String visitEqualityOperator(ExpressionParser.EqualityOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitComparisonExpression(ExpressionParser.ComparisonExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    public String visitComparisonOperator(ExpressionParser.ComparisonOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitAddExpression(ExpressionParser.AddExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    public String visitAddOperator(ExpressionParser.AddOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitMultExpression(ExpressionParser.MultExpressionContext ctx) {
        return ctx.children.stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(" "));
    }

    public String visitMultOperator(ExpressionParser.MultOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitUnaryExpression(ExpressionParser.UnaryExpressionContext ctx) {
        return Objects.isNull(ctx.primaryExpression()) ? (String)this.visit((ParseTree)ctx.unaryOperator()) + (String)this.visit((ParseTree)ctx.unaryExpression()) : (String)this.visit((ParseTree)ctx.primaryExpression());
    }

    public String visitUnaryOperator(ExpressionParser.UnaryOperatorContext ctx) {
        return ctx.getText();
    }

    public String visitExpressionInBraces(ExpressionParser.ExpressionInBracesContext ctx) {
        return "(" + (String)this.visit((ParseTree)ctx.expression()) + ")";
    }

    public String visitFunctionCall(ExpressionParser.FunctionCallContext ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(ctx.functionName().getText()).append("(");
        if (Objects.nonNull(ctx.functionParameters())) {
            sb.append((String)this.visit((ParseTree)ctx.functionParameters()));
        }
        sb.append(")");
        return sb.toString();
    }

    public String visitFunctionName(ExpressionParser.FunctionNameContext ctx) {
        return (String)super.visitFunctionName(ctx);
    }

    public String visitFunctionParameters(ExpressionParser.FunctionParametersContext ctx) {
        return ctx.expression().stream().map(arg_0 -> ((ExpressionVisitor)this).visit(arg_0)).collect(Collectors.joining(", "));
    }

    public String visitAttributeReference(ExpressionParser.AttributeReferenceContext ctx) {
        FieldKind kind = FieldKind.valueOf((String)ctx.attributeKind().getText().toUpperCase());
        List path = ctx.path().pathElement().stream().map(RuleContext::getText).map(arg_0 -> this.unescapePathElement(arg_0)).collect(Collectors.toList());
        FieldReference reference = new FieldReference(kind, path);
        return this.buildFieldReferenceText(reference);
    }

    public String visitConstantReference(ExpressionParser.ConstantReferenceContext ctx) {
        FieldReference reference = new FieldReference(FieldKind.CONSTANT, Collections.singletonList(this.unescapeConstantName(ctx.constantName.getText())));
        return this.buildFieldReferenceText(reference);
    }

    public String visitNullLiteral(ExpressionParser.NullLiteralContext ctx) {
        return ctx.getText();
    }

    public String visitNumberLiteral(ExpressionParser.NumberLiteralContext ctx) {
        return ctx.getText();
    }

    public String visitStringLiteral(ExpressionParser.StringLiteralContext ctx) {
        return ctx.getText();
    }

    public String visitBooleanLiteral(ExpressionParser.BooleanLiteralContext ctx) {
        return ctx.getText();
    }

    private String buildFieldReferenceText(FieldReference reference) {
        return "${" + (String)this.fieldIdResolver.apply(reference) + "}";
    }

    private String unescapePathElement(String s) {
        return EscapeUtil.unescape((String)s);
    }

    private String unescapeConstantName(String s) {
        return EscapeUtil.unescape((String)s);
    }
}

