/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder;

import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.tuple.Pair;
import org.codehaus.stax2.XMLStreamWriter2;
import org.qubership.integration.platform.catalog.model.library.ElementDescriptor;
import org.qubership.integration.platform.catalog.model.library.ElementType;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.Dependency;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ContainerChainElement;
import org.qubership.integration.platform.catalog.service.library.LibraryElementsService;
import org.qubership.integration.platform.catalog.util.ElementUtils;
import org.qubership.integration.platform.runtime.catalog.builder.BuilderConstants;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplateService;
import org.qubership.integration.platform.runtime.catalog.model.ChainRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class XmlBuilder {
    private static final Logger log = LoggerFactory.getLogger(XmlBuilder.class);
    private final TemplateService templateService;
    private final LibraryElementsService libraryService;
    private final ElementUtils elementUtils;

    @Autowired
    public XmlBuilder(TemplateService templateService, LibraryElementsService libraryService, ElementUtils elementUtils) {
        this.templateService = templateService;
        this.libraryService = libraryService;
        this.elementUtils = elementUtils;
    }

    public String build(List<ChainElement> elements) throws XMLStreamException, IOException {
        elements = this.elementUtils.splitCompositeTriggers(elements);
        List<ChainElement> startElements = elements.stream().filter(chainElement -> {
            ElementDescriptor descriptor = this.libraryService.getElementDescriptor(chainElement);
            boolean elementHasNoParent = chainElement.getParent() == null || "container".equals(chainElement.getParent().getType());
            return descriptor != null && (descriptor.getType() == ElementType.TRIGGER || descriptor.getType() == ElementType.REUSE || descriptor.getType() == ElementType.COMPOSITE_TRIGGER && elementHasNoParent && chainElement.getInputDependencies().isEmpty());
        }).collect(Collectors.toList());
        HashMap<String, String> routesWithCustomIdPlaceholder = new HashMap<String, String>();
        List<ChainRoute> routes = this.collectRoutes(startElements, routesWithCustomIdPlaceholder);
        StringWriter result = new StringWriter();
        XMLStreamWriter2 streamWriter = (XMLStreamWriter2)new WstxOutputFactory().createXMLStreamWriter((Writer)result);
        streamWriter.writeStartDocument();
        streamWriter.writeStartElement("routes");
        streamWriter.writeDefaultNamespace("http://camel.apache.org/schema/spring");
        for (ChainRoute chainRoute : routes) {
            streamWriter.writeStartElement("route");
            if (routesWithCustomIdPlaceholder.containsKey(chainRoute.getId())) {
                streamWriter.writeAttribute("id", (String)routesWithCustomIdPlaceholder.get(chainRoute.getId()));
            }
            if (this.isRouteReferencedFromAnother(chainRoute)) {
                streamWriter.writeEmptyElement("from");
                streamWriter.writeAttribute("uri", "direct:" + chainRoute.getId());
            }
            for (ChainElement chainElement2 : chainRoute.getElements()) {
                ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(chainElement2);
                ElementType type = elementDescriptor.getType();
                if (type == ElementType.TRIGGER && !BuilderConstants.ON_COMPLETION_EXCLUDE_TRIGGERS.contains(elementDescriptor.getName())) {
                    XmlBuilder.addOnCompletion(streamWriter);
                    XmlBuilder.addChainStart(streamWriter);
                }
                if (type == ElementType.CONTAINER) continue;
                streamWriter.writeRaw(this.templateService.applyTemplate(chainElement2));
            }
            if (chainRoute.getNextRoutes().size() > 1) {
                streamWriter.writeStartElement("multicast");
            }
            for (ChainRoute childRoute : chainRoute.getNextRoutes()) {
                streamWriter.writeEmptyElement("toD");
                streamWriter.writeAttribute("uri", "direct:" + childRoute.getId());
            }
            if (chainRoute.getNextRoutes().size() > 1) {
                streamWriter.writeEndElement();
            }
            streamWriter.writeEndElement();
            this.addWiretapBridgeRoute(chainRoute, streamWriter);
        }
        streamWriter.writeEndElement();
        streamWriter.writeEndDocument();
        streamWriter.flush();
        streamWriter.close();
        return result.toString();
    }

    private void addWiretapBridgeRoute(ChainRoute chainRoute, XMLStreamWriter2 streamWriter) throws XMLStreamException {
        for (ChainElement element : chainRoute.getElements()) {
            ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(element);
            String elementName = elementDescriptor.getName();
            if (!"split-async-2".equals(elementName) && !"split-async".equals(elementName)) continue;
            ContainerChainElement splitContainer = (ContainerChainElement)element;
            for (ChainElement splitElement : splitContainer.getElements()) {
                String splitElementName = this.libraryService.getElementDescriptor(splitElement).getName();
                if (!"async-split-element".equals(splitElementName) && !"async-split-element-2".equals(splitElementName)) continue;
                streamWriter.writeStartElement("route");
                XmlBuilder.addOnCompletion(streamWriter);
                streamWriter.writeEmptyElement("from");
                streamWriter.writeAttribute("uri", "direct:" + splitElement.getId() + "-on-completion");
                streamWriter.writeEmptyElement("toD");
                streamWriter.writeAttribute("uri", "direct:" + splitElement.getId());
                streamWriter.writeEndElement();
            }
        }
    }

    private static void addOnCompletion(XMLStreamWriter2 streamWriter) throws XMLStreamException {
        streamWriter.writeStartElement("onCompletion");
        streamWriter.writeEmptyElement("process");
        streamWriter.writeAttribute("ref", "chainFinishProcessor");
        streamWriter.writeEndElement();
    }

    private static void addChainStart(XMLStreamWriter2 streamWriter) throws XMLStreamException {
        streamWriter.writeEmptyElement("process");
        streamWriter.writeAttribute("ref", "chainStartProcessor");
    }

    private List<ChainRoute> collectRoutes(List<ChainElement> startElements, Map<String, String> routesWithCustomId) {
        LinkedList<ChainRoute> routes = new LinkedList<ChainRoute>();
        HashMap<String, ChainRoute> elementToRoute = new HashMap<String, ChainRoute>();
        LinkedList<Pair<ChainElement, ChainRoute>> stack = new LinkedList<Pair<ChainElement, ChainRoute>>();
        for (ChainElement startElement : startElements) {
            ChainRoute route = !"reuse".equals(startElement.getType()) ? new ChainRoute() : new ChainRoute(startElement.getOriginalId());
            routes.add(route);
            stack.push(Pair.of((Object)startElement, (Object)route));
            if (!startElement.getType().startsWith("sftp-trigger")) continue;
            routesWithCustomId.put(route.getId(), "%%{deployment-id-placeholder}-" + startElement.getId());
        }
        while (!stack.isEmpty()) {
            Pair currentElement = (Pair)stack.pop();
            ChainElement current = (ChainElement)currentElement.getLeft();
            ChainRoute currentRoute = (ChainRoute)currentElement.getRight();
            ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor(current);
            ElementType elementType = elementDescriptor.getType();
            if (currentRoute.getElements().isEmpty()) {
                elementToRoute.put(current.getId(), currentRoute);
            }
            currentRoute.getElements().add(current);
            boolean completeRoute = elementType == ElementType.TRIGGER || elementType == ElementType.COMPOSITE_TRIGGER || current.getOutputDependencies().size() != 1;
            for (Dependency dependency : current.getOutputDependencies()) {
                ChainElement nextElement = dependency.getElementTo();
                if (elementToRoute.containsKey(nextElement.getId())) {
                    ChainRoute nextRoute = (ChainRoute)elementToRoute.get(nextElement.getId());
                    currentRoute.getNextRoutes().add(nextRoute);
                    continue;
                }
                ChainRoute route = currentRoute;
                if (completeRoute || nextElement.getInputDependencies().size() > 1) {
                    route = new ChainRoute();
                    routes.add(route);
                    currentRoute.getNextRoutes().add(route);
                }
                stack.push((Pair<ChainElement, ChainRoute>)Pair.of((Object)dependency.getElementTo(), (Object)route));
            }
            if (!(current instanceof ContainerChainElement) || elementType == ElementType.CONTAINER) continue;
            if (!elementDescriptor.isOldStyleContainer()) {
                List<ChainRoute> containerRoutes = this.collectContainerSubRoutes((ContainerChainElement)current, elementToRoute, stack);
                routes.addAll(containerRoutes);
                continue;
            }
            for (ChainElement element : ((ContainerChainElement)current).getElements()) {
                ChainRoute branchRoute = new ChainRoute(element.getId());
                routes.add(branchRoute);
                for (Dependency outputDependency : element.getOutputDependencies()) {
                    ChainElement nextElement = outputDependency.getElementTo();
                    branchRoute.getNextRoutes().add(this.extractNextRoute(nextElement, routes, elementToRoute, stack));
                }
            }
        }
        return routes;
    }

    private List<ChainRoute> collectContainerSubRoutes(ContainerChainElement containerElement, Map<String, ChainRoute> elementToRoute, Deque<Pair<ChainElement, ChainRoute>> elementRouteStack) {
        LinkedList<ChainRoute> routes = new LinkedList<ChainRoute>();
        ElementDescriptor elementDescriptor = this.libraryService.getElementDescriptor((ChainElement)containerElement);
        if (!elementDescriptor.getAllowedChildren().isEmpty()) {
            for (ChainElement child : containerElement.getElements()) {
                if (!(child instanceof ContainerChainElement)) {
                    ChainRoute branchRoute = new ChainRoute(child.getId());
                    routes.add(branchRoute);
                    branchRoute.getNextRoutes().add(this.extractNextRoute(child, routes, elementToRoute, elementRouteStack));
                    continue;
                }
                ContainerChainElement childContainer = (ContainerChainElement)child;
                this.addContainerRoutes(routes, childContainer, elementToRoute, elementRouteStack);
            }
            return routes;
        }
        this.addContainerRoutes(routes, containerElement, elementToRoute, elementRouteStack);
        return routes;
    }

    private void addContainerRoutes(List<ChainRoute> routes, ContainerChainElement containerElement, Map<String, ChainRoute> elementToRoute, Deque<Pair<ChainElement, ChainRoute>> elementRouteStack) {
        ChainRoute containerRoute = new ChainRoute(containerElement.getId());
        routes.add(containerRoute);
        List<ChainElement> startElements = containerElement.getElements().stream().filter(element -> element.getInputDependencies().isEmpty()).toList();
        if (startElements.size() == 1) {
            elementRouteStack.push((Pair<ChainElement, ChainRoute>)Pair.of((Object)startElements.get(0), (Object)containerRoute));
            return;
        }
        for (ChainElement startElement : startElements) {
            ChainRoute nextRoute = this.extractNextRoute(startElement, routes, elementToRoute, elementRouteStack);
            containerRoute.getNextRoutes().add(nextRoute);
        }
    }

    private ChainRoute extractNextRoute(ChainElement element, List<ChainRoute> routes, Map<String, ChainRoute> elementToRoute, Deque<Pair<ChainElement, ChainRoute>> elementRouteStack) {
        if (elementToRoute.containsKey(element.getId())) {
            return elementToRoute.get(element.getId());
        }
        ChainRoute newRoute = new ChainRoute();
        routes.add(newRoute);
        elementRouteStack.push((Pair<ChainElement, ChainRoute>)Pair.of((Object)element, (Object)newRoute));
        elementToRoute.put(element.getId(), newRoute);
        return newRoute;
    }

    private boolean isRouteReferencedFromAnother(ChainRoute route) {
        if (route.getElements().isEmpty()) {
            return true;
        }
        ChainElement routeStart = route.getElements().get(0);
        return !routeStart.getInputDependencies().isEmpty() || routeStart.getParent() != null && !"container".equals(routeStart.getParent().getType());
    }
}

