/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.builder.templates.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.runtime.catalog.builder.templates.TemplatesHelper;
import org.qubership.integration.platform.runtime.catalog.builder.templates.helpers.PropertyHelperSource;

@TemplatesHelper(value="if-property")
public class IfPropertyHelper
extends PropertyHelperSource
implements Helper<String> {
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^\\?]+)(\\?.*)?");
    private static final String EQUALS = "equals";
    private static final String NOT_EQUALS = "not-equals";
    private static final String PRESENTED = "presented";
    private static final String NOT_PRESENTED = "not-presented";
    private static final String EMPTY = "empty";
    private static final String NOT_EMPTY = "not-empty";
    private static final String CONTAINS = "contains";
    private static final String NOT_CONTAINS = "not-contains";
    private static final String CONTAINS_QUERY_PARAMS = "contains-query-params";
    private static final String NOT_CONTAINS_QUERY_PARAMS = "not-contains-query-params";
    private static final String IN = "in";
    private static final String NOT_IN = "not-in";

    public Object apply(String propertyName, Options options) throws IOException {
        boolean result = this.test(propertyName, options);
        Options.Buffer buffer = options.buffer();
        if (result) {
            buffer.append(options.fn());
        } else {
            buffer.append(options.inverse());
        }
        return buffer;
    }

    private boolean test(String propertyName, Options options) {
        Set keySet = options.hash.keySet();
        if (CollectionUtils.isEmpty(keySet)) {
            throw new IllegalArgumentException("Operation must be provided");
        }
        String operation = ((String)keySet.iterator().next()).toLowerCase();
        String expected = (String)options.hash.get(operation);
        String actual = this.getPropertyStringValue(propertyName, options);
        Object actualObject = this.getPropertyValue(propertyName, options);
        return switch (operation) {
            case EQUALS -> {
                if (actual != null && actual.equals(expected)) {
                    yield true;
                }
                yield false;
            }
            case NOT_EQUALS -> {
                if (actual == null || !actual.equals(expected)) {
                    yield true;
                }
                yield false;
            }
            case CONTAINS -> {
                if (actual != null && actual.contains(expected)) {
                    yield true;
                }
                yield false;
            }
            case NOT_CONTAINS -> {
                if (actual == null || !actual.contains(expected)) {
                    yield true;
                }
                yield false;
            }
            case EMPTY -> {
                if (actualObject instanceof Collection) {
                    yield CollectionUtils.isEmpty((Collection)((Collection)actualObject));
                }
                yield StringUtils.isEmpty((CharSequence)actual);
            }
            case NOT_EMPTY -> {
                if (actualObject instanceof Collection) {
                    yield CollectionUtils.isNotEmpty((Collection)((Collection)actualObject));
                }
                yield StringUtils.isNotEmpty((CharSequence)actual);
            }
            case PRESENTED -> {
                if (actual != null) {
                    yield true;
                }
                yield false;
            }
            case NOT_PRESENTED -> {
                if (actual == null) {
                    yield true;
                }
                yield false;
            }
            case CONTAINS_QUERY_PARAMS -> this.containsQueryParams(actual);
            case NOT_CONTAINS_QUERY_PARAMS -> {
                if (!this.containsQueryParams(actual)) {
                    yield true;
                }
                yield false;
            }
            case IN -> {
                if (actual != null && this.equalsIn(actual, expected)) {
                    yield true;
                }
                yield false;
            }
            case NOT_IN -> {
                if (actual == null || !this.equalsIn(actual, expected)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unsupported operation: " + operation);
        };
    }

    private boolean containsQueryParams(String actual) {
        Matcher matcher;
        if (actual != null && (matcher = QUERY_PARAM_PATTERN.matcher(actual)).find()) {
            return matcher.group(2) != null;
        }
        return false;
    }

    private boolean equalsIn(String actual, String expected) {
        for (String item : expected.split(",")) {
            if (!actual.equals(item.strip())) continue;
            return true;
        }
        return false;
    }
}

