/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.mapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.qubership.integration.platform.runtime.catalog.mapper.DataTypeUtils;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ArrayType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.CompoundType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.ObjectType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeDefinition;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Element;

public class ElementMapBuilder {
    public Map<String, ElementWithContext> buildElementMap(DataType type) {
        return this.buildElementMap(type, Collections.emptyMap());
    }

    public Map<String, ElementWithContext> buildElementMap(DataType type, Map<String, TypeDefinition> definitionMap) {
        HashMap<String, ElementWithContext> elementMap = new HashMap<String, ElementWithContext>();
        this.recursivelyProcessElements(type, definitionMap, elementWithContext -> elementMap.put(elementWithContext.element().getId(), (ElementWithContext)elementWithContext), element -> elementMap.containsKey(element.getId()));
        return elementMap;
    }

    private void recursivelyProcessElements(DataType type, Map<String, TypeDefinition> definitionMap, Consumer<ElementWithContext> consumer, Predicate<Element> checkIfElementProcessed) {
        this.getAttributes(type, definitionMap).filter(i -> !checkIfElementProcessed.test(i.element())).forEach(i -> {
            consumer.accept((ElementWithContext)i);
            this.recursivelyProcessElements(i.element().getType(), i.context().definitionMap(), consumer, checkIfElementProcessed);
        });
    }

    private Stream<ElementWithContext> getAttributes(DataType dataType, Map<String, TypeDefinition> definitionMap) {
        DataTypeUtils.ResolveResult result = DataTypeUtils.resolveType(dataType, definitionMap);
        dataType = result.type();
        Map<String, TypeDefinition> definitions = DataTypeUtils.updateDefinitionMapFromType(definitionMap, dataType);
        if (dataType instanceof ArrayType) {
            ArrayType type = (ArrayType)dataType;
            return this.getAttributes(type.getItemType(), definitions);
        }
        if (dataType instanceof ObjectType) {
            ObjectType type = (ObjectType)dataType;
            return type.getSchema().getAttributes().stream().map(attribute -> new ElementWithContext((Element)attribute, new ElementContext(definitions)));
        }
        if (dataType instanceof CompoundType) {
            CompoundType type = (CompoundType)dataType;
            return type.getTypes().stream().flatMap(t -> this.getAttributes((DataType)t, definitions));
        }
        return Stream.empty();
    }

    public record ElementWithContext(Element element, ElementContext context) {
    }

    public record ElementContext(Map<String, TypeDefinition> definitionMap) {
    }
}

