/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.DataType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.NullType;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeDefinition;
import org.qubership.integration.platform.runtime.catalog.model.mapper.datatypes.TypeWithDefinitions;
import org.qubership.integration.platform.runtime.catalog.model.mapper.mapping.definition.Attribute;
import org.qubership.integration.platform.runtime.catalog.model.mapper.metadata.Metadata;
import org.qubership.integration.platform.runtime.catalog.model.mapper.metadata.ObjectWithMetadata;

public class MessageSchema
extends ObjectWithMetadata {
    @JsonProperty(value="headers", required=true)
    private Collection<Attribute> headers;
    @JsonProperty(value="properties", required=true)
    private Collection<Attribute> properties;
    @JsonProperty(value="body")
    private DataType body;

    @JsonCreator
    public MessageSchema(@JsonProperty(value="headers", required=true) Collection<Attribute> headers, @JsonProperty(value="properties", required=true) Collection<Attribute> properties, @JsonProperty(value="body") DataType body, @JsonProperty(value="metadata") Metadata metadata) {
        super(metadata);
        this.headers = Objects.isNull(headers) ? Collections.emptyList() : headers;
        this.properties = Objects.isNull(properties) ? Collections.emptyList() : properties;
        this.body = Objects.isNull(body) ? new NullType(null) : body;
    }

    public Collection<Attribute> getHeaders() {
        return this.headers;
    }

    public Collection<Attribute> getProperties() {
        return this.properties;
    }

    public DataType getBody() {
        return this.body;
    }

    public Map<String, DataType> getBodyDefinitions() {
        if (this.body instanceof TypeWithDefinitions) {
            return ((TypeWithDefinitions)this.body).getDefinitions().stream().collect(Collectors.toMap(TypeDefinition::getId, TypeDefinition::getType));
        }
        return Collections.emptyMap();
    }
}

