/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.runtime.catalog.model.exportimport.instructions.ImportInstructionResult;
import org.qubership.integration.platform.runtime.catalog.service.exportimport.instructions.ImportInstructionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/catalog/import-instructions"})
@CrossOrigin(origins={"*"})
@Tag(name="import-instructions-controller", description="Import Instructions Controller")
public class ImportInstructionsController {
    private static final Logger log = LoggerFactory.getLogger(ImportInstructionsController.class);
    private final ImportInstructionsService importInstructionsService;

    @Autowired
    public ImportInstructionsController(ImportInstructionsService importInstructionsService) {
        this.importInstructionsService = importInstructionsService;
    }

    @GetMapping(value={"/export"})
    @Operation(description="Export import instructions configuration")
    public ResponseEntity<Object> exportImportInstructionsConfig() {
        Pair<String, byte[]> importInstructions = this.importInstructionsService.exportImportInstructions();
        HttpHeaders header = new HttpHeaders();
        header.add("Content-Disposition", "attachment; filename=\"" + (String)importInstructions.getLeft() + "\"");
        header.add("Access-Control-Expose-Headers", "Content-Disposition");
        ByteArrayResource resource = new ByteArrayResource((byte[])importInstructions.getRight());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(header)).contentLength(resource.contentLength()).body((Object)resource);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    @Operation(extensions={@Extension(properties={@ExtensionProperty(name="x-api-kind", value="bwc")})}, description="Upload import instructions configuration from file")
    public ResponseEntity<List<ImportInstructionResult>> uploadImportInstructionsConfig(@RequestParam(value="file") @Parameter(description="Yaml file") MultipartFile file, @RequestHeader(required=false, value="labels") @Parameter(description="List of labels that should be added on uploaded instructions") Set<String> labels) {
        log.info("Request to upload import instructions config from file {}", (Object)file.getOriginalFilename());
        return ResponseEntity.ok(this.importInstructionsService.uploadImportInstructionsConfig(file, labels));
    }
}

