/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.rest.v1.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.qubership.integration.platform.catalog.exception.SpecificationImportWarningException;
import org.qubership.integration.platform.catalog.service.exportimport.SpecificationImportService;
import org.qubership.integration.platform.runtime.catalog.rest.v1.dto.system.ImportSpecificationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/v1/import"})
@Tag(name="specification-import-controller", description="Specification Import Controller")
public class SpecificationImportController {
    private static final Logger log = LoggerFactory.getLogger(SpecificationImportController.class);
    private final SpecificationImportService specificationImportService;

    @Autowired
    public SpecificationImportController(SpecificationImportService specificationImportService) {
        this.specificationImportService = specificationImportService;
    }

    @PostMapping
    @Operation(description="Import single specification from a file")
    public ResponseEntity<ImportSpecificationDTO> importSpecification(@RequestParam @Parameter(description="Specification group id") String specificationGroupId, @RequestParam @Parameter(description="Array of specification files") MultipartFile[] files) {
        String importId = this.specificationImportService.importSpecification(specificationGroupId, files);
        ImportSpecificationDTO responseDTO = new ImportSpecificationDTO(importId, false);
        responseDTO.setSpecificationGroupId(specificationGroupId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.accepted().location(ServletUriComponentsBuilder.fromCurrentRequest().path("/{importId}").buildAndExpand(new Object[]{responseDTO.getId()}).toUri())).body((Object)responseDTO);
    }

    @GetMapping(value={"/{importId}"}, produces={"application/json"})
    @Operation(description="Get specification import result")
    public ResponseEntity<ImportSpecificationDTO> getImport(@PathVariable @Parameter(description="Import id") String importId) {
        ImportSpecificationDTO responseDTO = new ImportSpecificationDTO();
        responseDTO.setId(importId);
        try {
            responseDTO.setDone(this.specificationImportService.importSessionIsDone(importId));
        }
        catch (SpecificationImportWarningException e) {
            responseDTO.setDone(true);
            responseDTO.setWarningMessage(e.getMessage());
        }
        return ResponseEntity.ok((Object)responseDTO);
    }
}

