/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.scheduler;

import java.net.SocketTimeoutException;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.integration.platform.catalog.consul.ConsulService;
import org.qubership.integration.platform.catalog.consul.exception.KVNotFoundException;
import org.qubership.integration.platform.catalog.service.ActionsLogService;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.service.RuntimeDeploymentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.web.client.ResourceAccessException;

@Component
public class TasksScheduler {
    private static final Logger log = LoggerFactory.getLogger(TasksScheduler.class);
    public static final String CHECK_FAILED_MSG = "Failed to check engines state in consul";
    private final ConsulService consulService;
    private final RuntimeDeploymentService runtimeDeploymentService;
    private final ActionsLogService actionsLogService;
    @Value(value="${qip.actions-log.cleanup.interval}")
    private String actionLogInterval;

    @Autowired
    public TasksScheduler(ConsulService consulService, RuntimeDeploymentService runtimeDeploymentService, ActionsLogService actionsLogService) {
        this.consulService = consulService;
        this.runtimeDeploymentService = runtimeDeploymentService;
        this.actionsLogService = actionsLogService;
    }

    @Scheduled(cron="${qip.actions-log.cleanup.cron}")
    public void cleanupActionsLog() {
        this.actionsLogService.deleteAllOldRecordsByInterval(this.actionLogInterval);
        log.info("Remove old records from actions log table");
    }

    @Scheduled(fixedDelay=2500L)
    public void checkEnginesState() {
        try {
            Pair pair = this.consulService.waitForEnginesStateUpdate();
            if (((Boolean)pair.getLeft()).booleanValue()) {
                log.debug("Engines state changes detected");
                this.runtimeDeploymentService.provideEnginesStateUpdate((Collection)pair.getRight());
            }
        }
        catch (KVNotFoundException kvnfe) {
            log.warn("Engines state KV is empty. {}", (Object)kvnfe.getMessage());
        }
        catch (CannotCreateTransactionException ccte) {
            log.error("Failed to check engines state in consul, {}", (Object)ccte.getMessage());
        }
        catch (ResourceAccessException rae) {
            if (rae.getCause() instanceof SocketTimeoutException) {
                log.warn("Failed to check engines state in consul, consul unavailable or too small timeout. Error message: {}", (Object)rae.getMessage());
            } else {
                log.error(CHECK_FAILED_MSG, (Throwable)rae);
            }
        }
        catch (Exception e) {
            log.error(CHECK_FAILED_MSG, (Throwable)e);
        }
    }

    @Scheduled(fixedDelay=2500L)
    public void checkDeploymentUpdates() {
        try {
            Pair response = this.consulService.waitForDeploymentsUpdate();
            if (((Boolean)response.getLeft()).booleanValue()) {
                DeploymentService.clearDeploymentsUpdateCache((Long)response.getRight());
            }
        }
        catch (KVNotFoundException kvnfe) {
            log.debug("Deployments update KV is empty. {}", (Object)kvnfe.getMessage());
        }
    }
}

