/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.qubership.integration.platform.catalog.util.DevModeUtil;
import org.qubership.integration.platform.runtime.catalog.kubernetes.KubeApiException;
import org.qubership.integration.platform.runtime.catalog.kubernetes.KubeOperator;
import org.qubership.integration.platform.runtime.catalog.model.MultiConsumer;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.EventActionType;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.KubeDeployment;
import org.qubership.integration.platform.runtime.catalog.model.kubernetes.operator.KubePod;
import org.qubership.integration.platform.runtime.catalog.service.DeploymentService;
import org.qubership.integration.platform.runtime.catalog.util.EngineDomainUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EngineService {
    private static final Logger log = LoggerFactory.getLogger(EngineService.class);
    private static final String ENGINE_NAME_LABEL = "name";
    private final KubeOperator operator;
    private final DeploymentService deploymentService;
    private final DevModeUtil devModeUtil;
    private final EngineDomainUtils domainUtils;
    private final Map<String, MultiConsumer.Consumer5<String, KubePod, String, EventActionType, String>> enginesCallbacks = new ConcurrentHashMap<String, MultiConsumer.Consumer5<String, KubePod, String, EventActionType, String>>();
    @Value(value="${qip.engine.app-check-custom-label}")
    private String engineAppCheckLabel;

    @Autowired
    public EngineService(KubeOperator operator, DeploymentService deploymentService, DevModeUtil devModeUtil, EngineDomainUtils domainUtils) {
        this.operator = operator;
        this.deploymentService = deploymentService;
        this.devModeUtil = devModeUtil;
        this.domainUtils = domainUtils;
    }

    public List<KubeDeployment> getDomains() throws KubeApiException {
        List<KubeDeployment> deployments = this.getDeployments();
        deployments.forEach(deployment -> deployment.setName(this.domainUtils.convertKubeDeploymentToDomainName(deployment.getName())));
        return deployments;
    }

    public KubeDeployment getDomainByName(String domainName) {
        return this.getDomains().stream().filter(domain -> domain.getName().equals(domainName)).findFirst().orElse(null);
    }

    private List<KubeDeployment> getDeployments() throws KubeApiException {
        return this.operator.getDeploymentsByLabel(this.engineAppCheckLabel);
    }

    public List<KubePod> getEnginesPods(String domainName) throws KubeApiException {
        return this.operator.getPodsByLabel(ENGINE_NAME_LABEL, this.getActiveKubeDeploymentNameByDomain(domainName));
    }

    public boolean isDevMode() {
        return this.devModeUtil.isDevMode();
    }

    public String subscribeEngines(MultiConsumer.Consumer5<String, KubePod, String, EventActionType, String> callback) {
        String id = UUID.randomUUID().toString();
        this.enginesCallbacks.put(id, callback);
        return id;
    }

    public long deploymentsCountByDomain(String domainName) {
        return this.deploymentService.getDeploymentsCountByDomain(domainName);
    }

    public String getActiveKubeDeploymentNameByDomain(String domainName) {
        for (KubeDeployment deployment : this.getDeployments()) {
            if (!this.domainUtils.convertKubeDeploymentToDomainName(deployment.getName()).equals(domainName)) continue;
            return deployment.getName();
        }
        return null;
    }
}

