/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpProducerPropertiesBuilder
implements ElementPropertiesBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpProducerPropertiesBuilder.class);
    public static final String REUSE_CONN_DEFAULT_VALUE = "true";

    @Override
    public boolean applicableTo(ChainElement element) {
        return Set.of("service-call", "http-sender", "graphql-sender").contains(element.getType());
    }

    @Override
    public Map<String, String> build(ChainElement element) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String type = element.getType();
        String reuseConn = null;
        switch (type) {
            case "service-call": {
                String protocol = (String)element.getProperties().get("integrationOperationProtocolType");
                Object operationPath = element.getProperties().get("integrationOperationPath");
                if (operationPath != null) {
                    properties.put("integrationOperationPath", operationPath.toString());
                }
                if ("http".equals(protocol) || "graphql".equals(protocol)) {
                    Map additionalParams = (Map)element.getProperties().get("integrationAdditionalParameters");
                    if (additionalParams != null && additionalParams.containsKey("reuseEstablishedConnection")) {
                        reuseConn = (String)additionalParams.get("reuseEstablishedConnection");
                        break;
                    }
                    if (element.getEnvironment() == null || element.getEnvironment().getProperties() == null) break;
                    reuseConn = (String)element.getEnvironment().getProperties().get("reuseEstablishedConnection");
                    break;
                }
                return Collections.emptyMap();
            }
            case "http-sender": 
            case "graphql-sender": {
                reuseConn = element.getPropertyAsString("reuseEstablishedConnection");
                if (!element.getProperties().containsKey("uri")) break;
                properties.put("integrationOperationPath", element.getProperties().get("uri").toString());
            }
        }
        properties.put("reuseEstablishedConnection", StringUtils.isEmpty((CharSequence)reuseConn) ? REUSE_CONN_DEFAULT_VALUE : reuseConn);
        return properties;
    }
}

