/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.qubership.integration.platform.catalog.persistence.configs.entity.chain.element.ChainElement;
import org.qubership.integration.platform.runtime.catalog.service.ElementService;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.ElementPropertiesBuilder;
import org.qubership.integration.platform.runtime.catalog.service.deployment.properties.builders.ChainCall2PropertiesBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpTriggerPropertiesBuilder
implements ElementPropertiesBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpTriggerPropertiesBuilder.class);
    private final ElementService elementService;

    @Autowired
    public HttpTriggerPropertiesBuilder(ElementService elementService) {
        this.elementService = elementService;
    }

    @Override
    public boolean applicableTo(ChainElement element) {
        String type = element.getType();
        return "http-trigger".equals(type);
    }

    @Override
    public Map<String, String> build(ChainElement element) {
        HashMap<String, String> returnProperties = new HashMap<String, String>();
        Map elementProperties = element.getProperties();
        if ("chain-call".equals(elementProperties.get("handleChainFailureAction"))) {
            returnProperties.putAll(ChainCall2PropertiesBuilder.getChainCallProperties(this.elementService, elementProperties.getOrDefault("chainFailureHandlerContainer", Collections.emptyMap())));
            returnProperties.put("actualElementChainIdOverrideForStep", "Failure response mapping");
        }
        return returnProperties;
    }
}

