/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.qubership.integration.platform.catalog.model.diagnostic.ValidationAlert;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractValidation {
    private static final Pattern ID_VALIDATION_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private final String id;
    private final String title;
    private final String description;
    private final String suggestion;
    private final ValidationEntityType entityType;
    private final ValidationImplementationType implementationType;
    private final ValidationSeverity severity;
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>();

    public AbstractValidation(String id, String title, String description, String suggestion, ValidationEntityType entityType, ValidationImplementationType implementationType, ValidationSeverity severity) {
        if (!ID_VALIDATION_PATTERN.matcher(id).find()) {
            throw new IllegalArgumentException("Validation has invalid ID: " + id + ". ID must match the pattern: " + ID_VALIDATION_PATTERN.pattern());
        }
        this.id = id;
        this.title = title;
        this.description = description;
        this.suggestion = suggestion;
        this.entityType = entityType;
        this.implementationType = implementationType;
        this.severity = severity;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public abstract Collection<? extends ValidationAlert> validate() throws DiagnosticValidationUnexpectedException;

    public void putProperties(Map<String, Serializable> props) {
        this.properties.putAll(props);
    }

    public void putProperty(String key, Serializable value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public ValidationEntityType getEntityType() {
        return this.entityType;
    }

    public ValidationImplementationType getImplementationType() {
        return this.implementationType;
    }

    public ValidationSeverity getSeverity() {
        return this.severity;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }
}

