/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.qubership.integration.platform.catalog.persistence.configs.entity.diagnostic.ValidationChainAlert;
import org.qubership.integration.platform.catalog.persistence.configs.repository.diagnostic.ElementValidationRepository;
import org.qubership.integration.platform.runtime.catalog.model.diagnostic.ValidationImplementationType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationEntityType;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.ValidationSeverity;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.DiagnosticValidationUnexpectedException;
import org.qubership.integration.platform.runtime.catalog.service.diagnostic.validations.builtin.BuiltinValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ScriptingFoundInChainValidation
extends BuiltinValidation {
    private static final Logger log = LoggerFactory.getLogger(ScriptingFoundInChainValidation.class);
    private final ElementValidationRepository elementRepository;

    public ScriptingFoundInChainValidation(ElementValidationRepository elementRepository) {
        super("scripting-found-in-chain_0WHKW1A3", "Scripting found in the chain", "Rule allows to find chains and chain elements which contain scripting.", "Scripting is not recommended, as it often causes unexpected harm to the data or instance if done incorrectly. Please consider replacing scripts with mapper, if possible.", ValidationEntityType.CHAIN_ELEMENT, ValidationImplementationType.BUILT_IN, ValidationSeverity.WARNING);
        this.elementRepository = elementRepository;
    }

    public Collection<ValidationChainAlert> validate() throws DiagnosticValidationUnexpectedException {
        try {
            return this.processValidation();
        }
        catch (Exception e) {
            throw new DiagnosticValidationUnexpectedException("Validation failed with an unexpected error: " + e.getMessage(), e);
        }
    }

    @NotNull
    private List<ValidationChainAlert> processValidation() {
        List containsScriptElements = this.elementRepository.findAllForExcessiveScriptUsageValidation();
        return containsScriptElements.stream().map(element -> ValidationChainAlert.builder().validationId(this.getId()).chain(element.getChain()).element(element).build()).toList();
    }
}

